/*
 * Decompiled with CFR 0.152.
 */
package com.sidneysimmons.gradlepluginexternalproperties;

import com.sidneysimmons.gradlepluginexternalproperties.exception.InvalidPropertyException;
import com.sidneysimmons.gradlepluginexternalproperties.exception.MissingPropertyException;
import com.sidneysimmons.gradlepluginexternalproperties.extension.ExternalPropertiesExtension;
import com.sidneysimmons.gradlepluginexternalproperties.resolver.PropertiesFileResolver;
import com.sidneysimmons.gradlepluginexternalproperties.resolver.PropertyResolver;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Project;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalPropertiesContainer {
    private static final Logger log = LoggerFactory.getLogger(ExternalPropertiesContainer.class);
    public static final String NAME = "props";
    private Project project;
    private ExternalPropertiesExtension extension;
    private List<PropertyResolver> defaultResolvers;

    public ExternalPropertiesContainer(Project project, ExternalPropertiesExtension extension) {
        this.project = project;
        this.extension = extension;
    }

    public String get(String propertyName) {
        String propertyValue = this.findPropertyValue(propertyName);
        if (propertyValue != null) {
            return propertyValue;
        }
        throw new MissingPropertyException(MessageFormat.format("External property not found. propertyName = {0}", propertyName));
    }

    public String get(String propertyName, String defaultValue) {
        String propertyValue = this.findPropertyValue(propertyName);
        if (propertyValue != null) {
            return propertyValue;
        }
        return defaultValue;
    }

    public Boolean exists(String propertyName) {
        String propertyValue = this.findPropertyValue(propertyName);
        if (propertyValue != null) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private String findPropertyValue(String propertyName) {
        propertyName = this.validatePropertyName(propertyName);
        log.debug("Trying to find value for external property \"" + propertyName + "\"...");
        for (Project tempProject = this.project; tempProject != null; tempProject = tempProject.getParent()) {
            log.debug("Looking in project " + tempProject + "...");
            ExternalPropertiesContainer tempContainer = (ExternalPropertiesContainer)tempProject.getExtensions().findByName(NAME);
            if (tempContainer == null) continue;
            log.debug("Property container found - looking at resolvers...");
            String property = null;
            for (PropertyResolver resolver : tempContainer.getResolvers()) {
                log.debug("Looking in resolver " + resolver + "...");
                property = resolver.resolve(propertyName);
                if (property == null) continue;
                log.debug("Property found.");
                return property;
            }
        }
        log.debug("Property not found.");
        return null;
    }

    private String validatePropertyName(String propertyName) {
        String string = propertyName = propertyName != null ? propertyName.trim() : null;
        if (propertyName == null || propertyName.isEmpty()) {
            throw new InvalidPropertyException(MessageFormat.format("External property name is invalid. propertyName = {0}", propertyName));
        }
        return propertyName;
    }

    public List<PropertyResolver> getResolvers() {
        List resolvers = (List)this.extension.getResolvers().get();
        if (!resolvers.isEmpty()) {
            return resolvers;
        }
        return this.getDefaultResolvers();
    }

    public List<PropertyResolver> getDefaultResolvers() {
        if (this.defaultResolvers == null) {
            this.defaultResolvers = new ArrayList<PropertyResolver>();
            log.debug("Configuring plugin provided default property resolvers for project " + this.project + ".");
            String userHomeDirectory = System.getProperty("user.home");
            String projectNameHierarchy = this.buildProjectNameHierarchy();
            String userDirectoryResolverString = MessageFormat.format("{0}/.gradle-plugin-external-properties/{1}/build.properties", userHomeDirectory, projectNameHierarchy);
            PropertiesFileResolver userDirectoryResolver = new PropertiesFileResolver(new File(userDirectoryResolverString));
            this.defaultResolvers.add(userDirectoryResolver);
            String projectDirectoryResolverString = MessageFormat.format("{0}/build.properties", this.project.getProjectDir().getAbsolutePath());
            PropertiesFileResolver projectDirectoryResolver = new PropertiesFileResolver(new File(projectDirectoryResolverString));
            this.defaultResolvers.add(projectDirectoryResolver);
        }
        return this.defaultResolvers;
    }

    private String buildProjectNameHierarchy() {
        String projectNameHierarchy = "";
        for (Project tempProject = this.project; tempProject != null; tempProject = tempProject.getParent()) {
            projectNameHierarchy = tempProject.getName() + "/" + projectNameHierarchy;
        }
        if (projectNameHierarchy.endsWith("/")) {
            projectNameHierarchy = projectNameHierarchy.substring(0, projectNameHierarchy.length() - 1);
        }
        return projectNameHierarchy;
    }
}

