/*
 * Decompiled with CFR 0.152.
 */
package com.sic.module.utils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.widget.Toast;
import com.sic.module.utils.AppContext;

public class Boast {
    private static final String TAG = Boast.class.getSimpleName();
    private static volatile Boast globalBoast = null;
    private Toast internalToast;

    private Boast(Toast toast) {
        if (toast == null) {
            throw new NullPointerException("Boast.Boast(Toast) requires a non-null parameter.");
        }
        this.internalToast = toast;
    }

    @SuppressLint(value={"ShowToast"})
    public static Boast makeText(Context context, CharSequence text, int duration) {
        return new Boast(Toast.makeText((Context)context, (CharSequence)text, (int)duration));
    }

    @SuppressLint(value={"ShowToast"})
    public static Boast makeText(Context context, int resId, int duration) throws Resources.NotFoundException {
        return new Boast(Toast.makeText((Context)context, (int)resId, (int)duration));
    }

    @SuppressLint(value={"ShowToast"})
    public static Boast makeText(Context context, CharSequence text) {
        return new Boast(Toast.makeText((Context)context, (CharSequence)text, (int)0));
    }

    @SuppressLint(value={"ShowToast"})
    public static Boast makeText(Context context, int resId) throws Resources.NotFoundException {
        return new Boast(Toast.makeText((Context)context, (int)resId, (int)0));
    }

    public static void showText(Context context, CharSequence text, int duration) {
        Boast.makeText(context, text, duration).show();
    }

    public static void showText(Context context, int resId, int duration) throws Resources.NotFoundException {
        Boast.makeText(context, resId, duration).show();
    }

    public static void showText(Context context, CharSequence text) {
        Boast.makeText(context, text, 0).show();
    }

    public static void showText(Context context, int resId) throws Resources.NotFoundException {
        Boast.makeText(context, resId, 0).show();
    }

    public static void showToast(String text) {
        Boast.showText(AppContext.getInstance().getContext(), text);
    }

    public static void showToast(int resId) {
        Boast.showText(AppContext.getInstance().getContext(), resId);
    }

    public static void showToast(final Activity activity, final String text) {
        if (activity == null) {
            return;
        }
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Boast.showText(activity.getApplicationContext(), text);
            }
        });
    }

    public static void showToast(final Activity activity, final int resId) {
        if (activity == null) {
            return;
        }
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                Boast.showText(activity.getApplicationContext(), resId);
            }
        });
    }

    public void cancel() {
        this.internalToast.cancel();
    }

    public void show() {
        this.show(true);
    }

    public void show(boolean cancelCurrent) {
        if (cancelCurrent && globalBoast != null) {
            globalBoast.cancel();
        }
        globalBoast = this;
        this.internalToast.show();
    }
}

