/*
 * Decompiled with CFR 0.152.
 */
package com.sic.module.nfc.tech.chips.sic431x;

import com.sic.module.nfc.tech.chips.SIC431x;
import com.sic.module.nfc.tech.chips.registers.IStatus;

public class Status
extends IStatus {
    private static final byte ADDRESS_UART_STATUS = 0;
    private static final byte ADDRESS_OSC_TUNING = 7;
    public static final byte CTS = BIT5;
    public static final byte RTS = BIT4;
    public static final byte DL_FF_EMT = BIT3;
    public static final byte DL_FF_OVF = BIT2;
    public static final byte UL_FF_EMT = BIT1;
    public static final byte UL_FF_OVF = BIT0;
    public static final byte UART_RDY = BIT3;
    private static final String TAG = Status.class.getName();
    private static Status instance;

    private Status(SIC431x sic431x) {
        super(sic431x);
    }

    public static Status getInstance(SIC431x sic431x) {
        if (instance == null) {
            instance = new Status(sic431x);
        }
        return instance;
    }

    @Override
    protected void setRegisterAddress() {
        ADDRESS_POWER_STATUS = 1;
    }

    @Override
    protected void setDefaultBit() {
        SCAP_RDY = BIT4;
        XVDD_RDY = BIT2;
        RSPW_RDY = BIT1;
        LDO_ON = BIT0;
    }

    public Byte getUARTStatus() {
        return this.getStatus(ADDRESS_POWER_STATUS);
    }

    public boolean isPowerUARTReady() {
        Byte flag = this.getPowerStatus();
        return flag != null && (flag & UART_RDY) == UART_RDY;
    }

    public boolean isExternalUARTReady() {
        Byte flag = this.getUARTStatus();
        return flag != null && (flag & CTS) == CTS;
    }

    public boolean isUplinkFIFOReady() {
        Byte flag = this.getUARTStatus();
        return flag != null && (flag & RTS) == RTS;
    }

    public boolean isDownlinkFIFOEmpty() {
        Byte flag = this.getUARTStatus();
        return flag != null && (flag & DL_FF_EMT) == DL_FF_EMT;
    }

    public boolean isDownlinkFIFOOverflow() {
        Byte flag = this.getUARTStatus();
        return flag != null && (flag & DL_FF_OVF) == DL_FF_OVF;
    }

    public boolean isUplinkFIFOEmpty() {
        Byte flag = this.getUARTStatus();
        return flag != null && (flag & UL_FF_EMT) == UL_FF_EMT;
    }

    public boolean isUplinkFIFOOverflow() {
        Byte flag = this.getUARTStatus();
        return flag != null && (flag & UL_FF_OVF) == UL_FF_OVF;
    }
}

