/*
 * Decompiled with CFR 0.152.
 */
package com.sic.module.nfc.tech.chips.registers;

import com.sic.module.nfc.tech.chips.SIC43xx;
import com.sic.module.nfc.tech.chips.sic4310.Register;
import com.sic.module.nfc.tech.interfaces.IDevice;
import com.sic.module.utils.SICLog;
import com.sic.module.utils.Utils;

public abstract class IUART
extends IDevice {
    private static final String TAG = IUART.class.getName();
    protected static byte ADDRESS_TRXRU_RESPONSE_TIME;
    protected static byte ADDRESS_UART_BYTE_CONFIGURATION;
    protected static byte ADDRESS_UART_DIVISOR_M;
    protected static byte ADDRESS_UART_DIVISOR_N;
    protected static int SPEED_OF_UART;
    protected static int TRxRURespTimeShiftBit;
    public static int MAX_SIZE_FIFO;
    public static int STOP_BITS;
    public static int PARITY;
    public static int TRXRU_RESPONSE_TIME;
    public static byte DIVISOR_M;
    public static byte DIVISOR_N;
    public static final int TRxRURespTime_1 = 1;
    public static final int TRxRURespTime_2 = 2;
    public static final int TRxRURespTime_4 = 4;
    public static final int TRxRURespTime_8 = 8;
    public static final int TRxRURespTime_16 = 16;
    public static final int TRxRURespTime_32 = 32;
    public static final int TRxRURespTime_64 = 64;
    public static final int TRxRURespTime_128 = 128;
    public static final int TRxRURespTime_256 = 256;
    public static final int TRxRURespTime_512 = 512;
    public static final int TRxRURespTime_1024 = 1024;
    public static final int TRxRURespTime_2048 = 2048;
    public static final int TRxRURespTime_4096 = 4096;
    public static int StopBits_1;
    public static int StopBits_2;
    public static int Parity_None;
    public static int Parity_Space;
    public static int Parity_Mask;
    public static int Parity_Even;
    public static int Parity_Odd;
    public static int Mode_Rx;
    public static int Mode_Tx;
    public static int Mode_RTS;
    public static int Mode_CTS;
    protected SIC43xx mSic43xx;

    protected IUART(SIC43xx sic43xx) {
        super(sic43xx.getRegister());
        this.mSic43xx = sic43xx;
    }

    public static byte[] getPackage_TxRU(byte[] data) {
        return Utils.getPackageLimited((byte)-79, data, MAX_SIZE_FIFO);
    }

    public static byte[][] getPackage_TxRU_Unlimited(byte[] ... data) {
        return Utils.getPackageSplit((byte)-79, data, MAX_SIZE_FIFO);
    }

    public static byte[] getPackage_RxUR() {
        return new byte[]{-78, 0};
    }

    public static byte[] getPackage_TRxRU(byte[] data) {
        return Utils.getPackageLimited((byte)-77, data, MAX_SIZE_FIFO);
    }

    public static byte[][] getPackage_TRxRU_Unlimited(byte[] ... data) {
        return Utils.getPackageSplit((byte)-79, (byte)-77, data, MAX_SIZE_FIFO);
    }

    public abstract byte getMode();

    public abstract void setMode(int var1);

    public void initUART() {
        this.initUART(115200, StopBits_1, Parity_None, Mode_Rx | Mode_Tx);
    }

    public void initUART(int baudRate) {
        this.initUART(baudRate, StopBits_1, Parity_None, Mode_Rx | Mode_Tx);
    }

    public void initUART(int baudRate, int UART_StopLen, int UART_Parity, int UART_Mode) {
        try {
            int n;
            int UARTRateDiv = SPEED_OF_UART / baudRate;
            int m = 1;
            for (n = UARTRateDiv; n > 48; n >>= 1) {
                m <<= 1;
            }
            byte[][] buffer = new byte[][]{{ADDRESS_UART_BYTE_CONFIGURATION, (byte)(UART_StopLen & STOP_BITS | UART_Parity & PARITY)}, {ADDRESS_UART_DIVISOR_M, (byte)m}, {ADDRESS_UART_DIVISOR_N, (byte)n}};
            this.mRegister.write(buffer);
            this.setMode(UART_Mode);
        }
        catch (Exception e) {
            SICLog.e(TAG, e.getMessage());
        }
    }

    public int getBaudRate() {
        int m = this.mRegister.readBuffer(ADDRESS_UART_DIVISOR_M) & DIVISOR_M;
        int n = this.mRegister.readBuffer(ADDRESS_UART_DIVISOR_N) & DIVISOR_N;
        if (n < 2) {
            return -1;
        }
        if (m == 0) {
            m = 64;
        }
        return SPEED_OF_UART / (m * n);
    }

    public void setBaudRate(int baudRate) {
        int n;
        int bitRate = SPEED_OF_UART / baudRate;
        int m = 1;
        for (n = bitRate; n > 48; n >>= 1) {
            m <<= 1;
        }
        this.mRegister.write({ADDRESS_UART_DIVISOR_M, (byte)m}, {ADDRESS_UART_DIVISOR_N, (byte)n});
    }

    public byte getStopLength() {
        return (byte)(this.mRegister.readBuffer(ADDRESS_UART_BYTE_CONFIGURATION) & STOP_BITS);
    }

    public void setStopLength(int UART_StopLen) {
        this.mRegister.writeParams(ADDRESS_UART_BYTE_CONFIGURATION, STOP_BITS, UART_StopLen);
    }

    public byte getParity() {
        return (byte)(this.mRegister.readBuffer(ADDRESS_UART_BYTE_CONFIGURATION) & PARITY);
    }

    public void setParity(int UART_Parity) {
        this.mRegister.writeParams(ADDRESS_UART_BYTE_CONFIGURATION, PARITY, UART_Parity);
    }

    public int getTRxRUResponseTime() {
        int time = (this.mRegister.readBuffer(ADDRESS_TRXRU_RESPONSE_TIME) & TRXRU_RESPONSE_TIME) >> TRxRURespTimeShiftBit;
        return (int)Math.pow(2.0, time);
    }

    public int setTRxRUResponseTime(int time) {
        time = ((int)Math.ceil(Math.log(time) / Math.log(2.0)) & TRXRU_RESPONSE_TIME) >> TRxRURespTimeShiftBit;
        this.mRegister.write(ADDRESS_TRXRU_RESPONSE_TIME, time);
        time = (int)Math.pow(2.0, time);
        this.mSic43xx.setTimeout(time + 128);
        return time;
    }

    public byte[] send(byte[] ... data) {
        this.mSic43xx.clearDataStream();
        this.mSic43xx.addDataStream(IUART.getPackage_TxRU_Unlimited(data));
        this.mSic43xx.stream();
        return this.mSic43xx.getDataStreamAtLatestIndex();
    }

    public byte[] receive() {
        return this.mSic43xx.autoTransceive(IUART.getPackage_RxUR());
    }

    public void clearFIFO() {
        this.mSic43xx.clearDataStream();
        this.mSic43xx.addDataStream(new byte[][]{Register.getPackage_ClearFlags()});
        this.mSic43xx.addDataStream(new byte[][]{IUART.getPackage_RxUR()});
        this.mSic43xx.stream();
    }

    public byte[] TxRUTranceiver(int ncommand, byte[] ... data) {
        int flag;
        byte[] rxBuffer;
        this.mSic43xx.clearDataStream();
        this.mSic43xx.addDataStream(IUART.getPackage_TxRU_Unlimited(data));
        this.mSic43xx.stream();
        boolean protect = this.mSic43xx.isProtection();
        this.mSic43xx.setProtection(false);
        do {
            if ((rxBuffer = this.receive()) != null && rxBuffer.length >= 1) continue;
            this.mSic43xx.setProtection(true);
            return null;
        } while ((rxBuffer[0] & (flag = -126)) == flag && ncommand-- > 0);
        this.mSic43xx.setProtection(protect);
        return rxBuffer;
    }

    public byte[] TRxRUTranceiver(byte[] ... data) {
        this.mSic43xx.clearDataStream();
        this.mSic43xx.addDataStream(IUART.getPackage_TRxRU_Unlimited(data));
        this.mSic43xx.stream();
        return this.mSic43xx.getDataStreamAtLatestIndex();
    }

    public byte[] TRxRUTranceiver(int time, byte[] ... data) {
        time = ((int)Math.ceil(Math.log(time) / Math.log(2.0)) & TRXRU_RESPONSE_TIME) >> TRxRURespTimeShiftBit;
        this.mSic43xx.clearDataStream();
        this.mSic43xx.addDataStream(new byte[][]{Register.getPackage_Write(ADDRESS_TRXRU_RESPONSE_TIME, time)});
        this.mSic43xx.addDataStream(IUART.getPackage_TRxRU_Unlimited(data));
        time = (int)Math.pow(2.0, time);
        this.mSic43xx.setTimeout(time + 128);
        this.mSic43xx.stream();
        return this.mSic43xx.getDataStreamAtLatestIndex();
    }
}

