/*
 * Decompiled with CFR 0.152.
 */
package com.sic.module.nfc.tech.chips.registers;

import com.sic.module.nfc.tech.chips.SIC43xx;
import com.sic.module.nfc.tech.interfaces.IDevice;

public abstract class IStatus
extends IDevice {
    private static final String TAG = IStatus.class.getName();
    protected static int ADDRESS_POWER_STATUS;
    public static int SCAP_RDY;
    public static int XVDD_RDY;
    public static int RSPW_RDY;
    public static int LDO_ON;
    private static final int TIMEOUT_OF_STATUS = 500;
    private long latestTime = 0L;

    protected IStatus(SIC43xx sic43xx) {
        super(sic43xx.getRegister());
    }

    protected Byte getStatus(int address) {
        long time = System.currentTimeMillis();
        Byte status = time - this.latestTime < 500L ? Byte.valueOf(this.mRegister.readBuffer(address)) : this.mRegister.read(address);
        this.latestTime = time;
        return status;
    }

    public Byte getPowerStatus() {
        return this.getStatus(ADDRESS_POWER_STATUS);
    }

    public boolean isPowerSuperCapReady() {
        Byte flag = this.getPowerStatus();
        return flag != null && (flag & SCAP_RDY) == SCAP_RDY;
    }

    public boolean isPowerXVDDReady() {
        Byte flag = this.getPowerStatus();
        return flag != null && (flag & XVDD_RDY) == XVDD_RDY;
    }

    public boolean isReservePowerReady() {
        Byte flag = this.getPowerStatus();
        return flag != null && (flag & RSPW_RDY) == RSPW_RDY;
    }

    public boolean isLDORegulatorOn() {
        Byte flag = this.getPowerStatus();
        return flag != null && (flag & LDO_ON) == LDO_ON;
    }
}

