/*
 * Decompiled with CFR 0.152.
 */
package com.sic.module.nfc.tech.chips;

import android.content.Context;
import com.sic.module.nfc.tech.chips.SIC43xx;
import com.sic.module.nfc.tech.chips.sic4310.UART;
import com.sic.module.nfc.tech.chips.sic431x.Status;
import com.sic.module.utils.Utils;

public abstract class SIC431x
extends SIC43xx {
    private static final String TAG = SIC431x.class.getName();
    private Status mStatus;

    protected SIC431x(Context context) {
        super(context);
        this.setPeripheral();
        this.mStatus = Status.getInstance(this);
    }

    protected abstract void setPeripheral();

    @Override
    public int addDataStream(byte[] ... buffer) {
        int index = 0;
        for (byte[] temp : buffer) {
            byte[][] chunk = Utils.chunkSplit(temp, UART.MAX_SIZE_FIFO + 1);
            index = super.addDataStream(chunk);
        }
        return index;
    }

    public Status getStatus() {
        return this.mStatus;
    }

    public boolean isDownlinkFIFOOverflow() {
        int flag = -127;
        return (this.response & flag) == flag;
    }

    public boolean isUplinkFIFOEmpty() {
        int flag = -126;
        return (this.response & flag) == flag;
    }

    public boolean isUplinkFIFOOverflow() {
        int flag = -124;
        return (this.response & flag) == flag;
    }

    public boolean isInsufficientPowerToSourceLoad() {
        int flag = -120;
        return (this.response & flag) == flag;
    }

    public boolean isVoltageOnXVddDrop() {
        int flag = -112;
        return (this.response & flag) == flag;
    }

    public boolean isUARTFail() {
        int flag = -96;
        return (this.response & flag) == flag;
    }
}

