/*
 * Decompiled with CFR 0.152.
 */
package com.sic.module.nfc.tech.chips;

import android.content.Context;
import com.sic.module.nfc.tech.chips.SIC431x;
import com.sic.module.nfc.tech.chips.sic4310.GPIO;
import com.sic.module.nfc.tech.chips.sic4310.Peripheral;
import com.sic.module.nfc.tech.chips.sic4310.Register;
import com.sic.module.nfc.tech.chips.sic4310.UART;
import com.sic.module.utils.AppContext;

public class SIC4310
extends SIC431x {
    private static final byte SIC4310_UID = 2;
    private static final String TAG = SIC4310.class.getName();
    private static SIC4310 instance;
    private GPIO mGPIO;
    private UART mUART;
    private Peripheral mPeripheral;

    private SIC4310(Context context) {
        super(context);
    }

    public static SIC4310 getInstance() {
        return SIC4310.getInstance(AppContext.getInstance().getContext());
    }

    public static SIC4310 getInstance(Context context) {
        if (instance == null) {
            instance = new SIC4310(context);
        }
        return instance;
    }

    @Override
    public boolean checkedUID() {
        byte[] uid = this.getUID();
        return uid != null && uid.length == 7 && uid[1] == 2;
    }

    @Override
    protected void setPeripheral() {
        this.mRegister = Register.getInstance(this);
        this.mGPIO = GPIO.getInstance(this);
        this.mPeripheral = Peripheral.getInstance(this);
        this.mUART = UART.getInstance(this);
    }

    public Peripheral getPeripheral() {
        return this.mPeripheral;
    }

    public GPIO getGPIO() {
        return this.mGPIO;
    }

    public UART getUART() {
        return this.mUART;
    }
}

