/*
 * Decompiled with CFR 0.152.
 */
package com.sic.module.utils;

import android.util.Log;

public class Buffer {
    private static final String TAG = Buffer.class.getSimpleName();
    final int length;
    final byte[] data;
    final boolean[] sync;

    public Buffer(int length) {
        this.length = length;
        this.data = new byte[length];
        this.sync = new boolean[length];
    }

    public static Buffer newInstance(int length) {
        return new Buffer(length);
    }

    public void set(int index, byte data) {
        if (index >= this.length) {
            return;
        }
        this.data[index] = data;
        this.sync[index] = true;
    }

    public void set(byte[] index, byte[] data) {
        if (index.length != data.length) {
            Log.wtf((String)TAG, (String)"size is mismatch");
            return;
        }
        int length = index.length;
        for (int i = 0; i < length; ++i) {
            this.data[index[i]] = data[i];
            this.sync[index[i]] = true;
        }
    }

    public Byte get(int index) {
        if (index >= this.length) {
            return null;
        }
        if (!this.sync[index]) {
            return null;
        }
        return this.data[index];
    }

    public boolean isSync(int index) {
        return this.sync[index];
    }

    public boolean isSyncAll() {
        for (boolean s : this.sync) {
            if (s) continue;
            return false;
        }
        return true;
    }
}

