/*
 * Decompiled with CFR 0.152.
 */
package com.sic.module.nfc.tech.optionals;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.nfc.FormatException;
import android.nfc.NdefMessage;
import android.nfc.NdefRecord;
import android.nfc.Tag;
import android.nfc.tech.Ndef;
import android.nfc.tech.NdefFormatable;
import com.sic.module.nfc.Nfc;
import com.sic.module.utils.AppContext;
import com.sic.module.utils.SICLog;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class NfcTypeNdef
extends Nfc {
    private static final String TAG = NfcTypeNdef.class.getName();
    private static NfcTypeNdef instance;
    private final Context mContext;
    private Ndef ndef;
    private NdefFormatable ndefFormatable;
    private NdefRecord[] records = new NdefRecord[0];
    private int recordCount = 0;

    private NfcTypeNdef(Context context) {
        super(context, null, new String[][]{{Ndef.class.getName(), NdefFormatable.class.getName()}});
        this.mContext = context;
    }

    private NfcTypeNdef() {
        this(AppContext.getInstance().getContext());
    }

    public static NfcTypeNdef getInstance() {
        if (instance == null) {
            instance = new NfcTypeNdef();
        }
        return instance;
    }

    public static NfcTypeNdef getInstance(Context context) {
        if (instance == null) {
            instance = new NfcTypeNdef(context);
        }
        return instance;
    }

    public Context getContext() {
        return this.mContext;
    }

    @Override
    public boolean onTagFinding(Intent intent) {
        if (super.onTagFinding(intent)) {
            this.ndef = Ndef.get((Tag)this.getTag());
            this.ndefFormatable = NdefFormatable.get((Tag)this.getTag());
            return true;
        }
        return false;
    }

    public void onTagFinding(Tag tag) {
        this.ndef = Ndef.get((Tag)tag);
        this.ndefFormatable = NdefFormatable.get((Tag)tag);
    }

    public NdefRecord createTextRecord(String text) throws UnsupportedEncodingException {
        String lang = "en";
        byte[] textBytes = text.getBytes();
        byte[] langBytes = lang.getBytes("US-ASCII");
        int langLength = langBytes.length;
        int textLength = textBytes.length;
        byte[] payload = new byte[1 + langLength + textLength];
        payload[0] = (byte)langLength;
        System.arraycopy(langBytes, 0, payload, 1, langLength);
        System.arraycopy(textBytes, 0, payload, 1 + langLength, textLength);
        return new NdefRecord(1, NdefRecord.RTD_TEXT, new byte[0], payload);
    }

    public NdefMessage createDataRecord(byte[] payload) throws FormatException {
        return new NdefMessage(payload);
    }

    @TargetApi(value=14)
    public NdefRecord createAppRecord(String appLocation) {
        return NdefRecord.createApplicationRecord((String)appLocation);
    }

    @TargetApi(value=14)
    public NdefRecord createURIRecord(String uriLocation) {
        return NdefRecord.createUri((String)uriLocation);
    }

    public void addRecords(NdefRecord newRecord) {
        NdefRecord[] oldRecords = new NdefRecord[this.recordCount];
        System.arraycopy(this.records, 0, oldRecords, 0, this.recordCount);
        this.records = new NdefRecord[this.recordCount + 1];
        System.arraycopy(oldRecords, 0, this.records, 0, this.recordCount);
        this.records[this.recordCount] = newRecord;
        ++this.recordCount;
    }

    public void removeRecords(int index) {
        if (index < this.recordCount) {
            NdefRecord[] recordsP1 = new NdefRecord[index];
            NdefRecord[] recordsP2 = new NdefRecord[this.recordCount - (index + 1)];
            if (index > 0) {
                System.arraycopy(this.records, 0, recordsP1, 0, index);
            }
            if (this.recordCount - (index + 1) > 0) {
                System.arraycopy(this.records, index + 1, recordsP2, 0, this.recordCount - (index + 1));
            }
            this.records = new NdefRecord[this.recordCount - 1];
            if (index > 0) {
                System.arraycopy(recordsP1, 0, this.records, 0, index);
            }
            if (this.recordCount - (index + 1) > 0) {
                System.arraycopy(recordsP2, 0, this.records, index, this.recordCount - (index + 1));
            }
            --this.recordCount;
        }
    }

    public void clearRecords() {
        this.recordCount = 0;
        this.records = new NdefRecord[this.recordCount];
    }

    public boolean writeNDEF() throws IOException, FormatException {
        try {
            NdefMessage message = new NdefMessage(this.records);
            if (this.ndef != null) {
                this.ndef.close();
                if (!this.ndef.isConnected()) {
                    this.ndef.connect();
                }
                if (!this.ndef.isWritable()) {
                    SICLog.i(TAG, "Read-only tag.");
                    this.ndef.close();
                    return false;
                }
                int size = message.toByteArray().length;
                if (this.ndef.getMaxSize() < size) {
                    SICLog.i(TAG, "Tag doesn't have enough free space.");
                    this.ndef.close();
                    return false;
                }
                this.ndef.writeNdefMessage(message);
                SICLog.i(TAG, "Tag written successfully.");
                this.ndef.close();
                return true;
            }
            if (this.ndefFormatable != null) {
                try {
                    this.ndefFormatable.connect();
                    this.ndefFormatable.format(message);
                    SICLog.i(TAG, "Tag written successfully!");
                    this.ndefFormatable.close();
                    return true;
                }
                catch (IOException e) {
                    SICLog.e(TAG, "Unable to format tag to NDEF.");
                    throw new IOException();
                }
            }
            SICLog.i(TAG, "Tag doesn't appear to support NDEF format.");
            return false;
        }
        catch (Exception e) {
            SICLog.e(TAG, "Failed to write tag" + e.toString());
            throw new IOException();
        }
    }

    public int getMaxSize() {
        return this.ndef.getMaxSize();
    }

    public String getType() {
        return this.ndef.getType();
    }

    public Boolean isWritable() {
        return this.ndef.isWritable();
    }

    public NdefMessage getCachedNdefMessage() {
        return this.ndef.getCachedNdefMessage();
    }

    public Ndef getRawNdef() {
        return this.ndef;
    }

    public NdefFormatable getRawNdefFormatable() {
        return this.ndefFormatable;
    }
}

