/*
 * Decompiled with CFR 0.152.
 */
package com.sic.module.nfc.tech.chips.s431x;

import android.util.Log;
import com.sic.module.nfc.tech.chips.s431x.SIC431x;
import com.sic.module.nfc.tech.chips.s431x.xCommand;
import com.sic.module.nfc.tech.interfaces.ICommand;
import com.sic.module.nfc.tech.interfaces.IRegister;
import com.sic.module.utils.Buffer;

public abstract class xRegister
implements IRegister {
    public static final byte FLAG_B_ACK = 26;
    public static final byte FLAG_B_NAK = -128;
    public static final byte FLAG_C_FLUSH_TX_FIFO = 1;
    public static final byte FLAG_C_FLUSH_RX_FIFO = 2;
    public static final byte FLAG_C_CLEAR_PWR_LOW_FLAG = 4;
    public static final byte FLAG_C_CLEAR_XVDD_DROP_FLAG = 8;
    public static final byte FLAG_C_CLEAR_OSC_STOP_FLAG = 16;
    public static final byte FLAG_B_NAK_DL_FIFO_OVF = 1;
    public static final byte FLAG_B_NAK_UL_FIFO_EMP = 2;
    public static final byte FLAG_B_NAK_UL_FIFO_OVF = 4;
    public static final byte FLAG_B_NAK_RSPW_LOW = 8;
    public static final byte FLAG_B_NAK_XVDD_DROP = 16;
    public static final byte FLAG_B_NAK_UART_FAIL = 32;
    private static final String TAG = xRegister.class.getSimpleName();
    private final SIC431x mSIC431x = SIC431x.getInstance();
    private final Buffer mRegBuffer = Buffer.newInstance(this.getRegisterPage());

    protected abstract int getRegisterPage();

    public boolean sync() {
        int length = this.getRegisterPage();
        byte[] address = new byte[length];
        for (int i = 0; i < length; ++i) {
            address[i] = (byte)i;
        }
        return this.read(address) != null;
    }

    public boolean isSync() {
        return this.mRegBuffer.isSyncAll();
    }

    public Byte read(byte addr) {
        byte[] recv = this.mSIC431x.commandsTransceive((ICommand)xCommand.READ_REGISTER_PAGE, new byte[]{addr});
        if (recv == null || recv.length == 0) {
            return null;
        }
        this.mRegBuffer.set(addr, recv[1]);
        return recv[1];
    }

    public byte[] read(byte ... addr) {
        int i;
        int length = addr.length;
        byte[] recv = new byte[length];
        Object transeiver = new byte[length][];
        for (i = 0; i < length; ++i) {
            transeiver[i] = new byte[]{addr[i]};
        }
        transeiver = this.mSIC431x.commandsTransceive((ICommand)xCommand.READ_REGISTER_PAGE, (byte[][])transeiver);
        if (this.mSIC431x.isSendCompleted()) {
            for (i = 0; i < length; ++i) {
                recv[i] = transeiver[i][1];
            }
            this.mRegBuffer.set(addr, recv);
            return recv;
        }
        return null;
    }

    public Byte readBuffer(byte addr) {
        return this.mRegBuffer.get(addr);
    }

    public Byte[] readBuffer(byte ... addr) {
        int length = addr.length;
        Byte[] recv = new Byte[length];
        for (int i = 0; i < length; ++i) {
            recv[i] = this.mRegBuffer.get(addr[i]);
        }
        return recv;
    }

    public void write(byte addr, byte data) {
        this.mSIC431x.commandsTransceive((ICommand)xCommand.WRITE_REGISTER_PAGE, new byte[]{addr, data});
        if (this.mSIC431x.isSendCompleted()) {
            this.mRegBuffer.set(addr, data);
        }
    }

    public void write(byte[] ... multi_data) {
        this.mSIC431x.commandsTransceive((ICommand)xCommand.WRITE_REGISTER_PAGE, multi_data);
        if (this.mSIC431x.isSendCompleted()) {
            for (byte[] data : multi_data) {
                this.mRegBuffer.set(data[0], data[1]);
            }
        }
    }

    public void writeParams(byte addr, int params, int raw) {
        Byte buff = this.mRegBuffer.get(addr);
        if (buff == null) {
            Log.w((String)TAG, (String)"It cannot write, register buffer is empty.");
            return;
        }
        byte data = (byte)(raw & params | buff & ~params);
        this.write(addr, data);
    }
}

