/*
 * Decompiled with CFR 0.152.
 */
package com.sic.module.nfc.tech.chips.s431x;

import com.sic.module.nfc.tech.interfaces.ICommand;

public enum xCommand implements ICommand
{
    TXRU(8010){

        @Override
        public byte[] getBuffer(byte[] data) {
            if (this.checkDataBuffer(data, 1, 64)) {
                int datlen = data.length;
                byte[] buffer = new byte[datlen + 1];
                buffer[0] = -79;
                System.arraycopy(data, 0, buffer, 1, datlen);
                return buffer;
            }
            return null;
        }
    }
    ,
    RXUR(8020){

        @Override
        public byte[] getBuffer(byte[] data) {
            if (this.checkDataBuffer(data, 1, data.length)) {
                byte[] buffer = new byte[]{-78, data[0]};
                return buffer;
            }
            return null;
        }
    }
    ,
    TRXRU(8030){

        @Override
        public byte[] getBuffer(byte[] data) {
            if (this.checkDataBuffer(data, 1, 64)) {
                int datlen = data.length;
                byte[] buffer = new byte[datlen + 1];
                buffer[0] = -77;
                System.arraycopy(data, 0, buffer, 1, datlen);
                return buffer;
            }
            return null;
        }
    }
    ,
    CLEAR_FLAGS(8040){

        @Override
        public byte[] getBuffer(byte[] data) {
            if (this.checkDataBuffer(data, 1, data.length)) {
                byte[] buffer = new byte[]{-76, data[0]};
                return buffer;
            }
            return null;
        }
    }
    ,
    READ_REGISTER_PAGE(8050){

        @Override
        public byte[] getBuffer(byte[] data) {
            if (this.checkDataBuffer(data, 1, data.length)) {
                byte[] buffer = new byte[]{-75, data[0]};
                return buffer;
            }
            return null;
        }
    }
    ,
    WRITE_REGISTER_PAGE(8060){

        @Override
        public byte[] getBuffer(byte[] data) {
            if (this.checkDataBuffer(data, 2, data.length)) {
                byte[] buffer = new byte[3];
                buffer[0] = -74;
                System.arraycopy(data, 0, buffer, 1, 2);
                return buffer;
            }
            return null;
        }
    };

    private final int commandID;

    private xCommand(int commandID) {
        this.commandID = commandID;
    }

    @Override
    public int getID() {
        return this.commandID;
    }

    @Override
    public abstract byte[] getBuffer(byte[] var1);

    @Override
    public boolean checkDataBuffer(byte[] data, int min_size, int max_size) {
        return data != null && min_size >= 0 && data.length >= min_size && data.length <= max_size;
    }
}

