/*
 * Decompiled with CFR 0.152.
 */
package com.sic.module.nfc.tech.chips.s431x;

import android.content.Context;
import com.sic.module.nfc.tech.chips.SIC43xx;
import com.sic.module.nfc.tech.chips.extension.ExtDevice;
import com.sic.module.nfc.tech.chips.s431x.xCommand;
import com.sic.module.nfc.tech.interfaces.ICommand;
import com.sic.module.nfc.tech.mandatories.NfcTypeA;
import com.sic.module.utils.AppContext;
import com.sic.module.utils.Utils;

public class SIC431x
extends SIC43xx {
    public static final int MAX_SIZE_PACKET = 64;
    private static final String TAG = SIC431x.class.getName();
    private static SIC431x instance;
    protected ExtDevice exInstance;

    protected SIC431x(Context context) {
        super(context);
    }

    public static SIC431x getInstance() {
        return SIC431x.getInstance(AppContext.getInstance().getContext());
    }

    public static SIC431x getInstance(Context context) {
        if (instance == null) {
            instance = new SIC431x(context);
        }
        return instance;
    }

    public static String getFlagName(byte flag) {
        switch (flag) {
            case 26: {
                return "B_ACK";
            }
        }
        String rtFlag = "";
        int cFlag = -128;
        if ((flag & cFlag) == cFlag) {
            cFlag = 1;
            if ((flag & cFlag) == cFlag) {
                if (!rtFlag.isEmpty()) {
                    rtFlag = rtFlag + "/";
                }
                rtFlag = rtFlag + "DL_FIFO_OVF";
            }
            if ((flag & (cFlag = 2)) == cFlag) {
                if (!rtFlag.isEmpty()) {
                    rtFlag = rtFlag + "/";
                }
                rtFlag = rtFlag + "UL_FIFO_EMP";
            }
            if ((flag & (cFlag = 4)) == cFlag) {
                if (!rtFlag.isEmpty()) {
                    rtFlag = rtFlag + "/";
                }
                rtFlag = rtFlag + "UL_FIFO_OVF";
            }
            if ((flag & (cFlag = 8)) == cFlag) {
                if (!rtFlag.isEmpty()) {
                    rtFlag = rtFlag + "/";
                }
                rtFlag = rtFlag + "PWR_LOW";
            }
            if ((flag & (cFlag = 16)) == cFlag) {
                if (!rtFlag.isEmpty()) {
                    rtFlag = rtFlag + "/";
                }
                rtFlag = rtFlag + "XVDD_DROP";
            }
            if ((flag & (cFlag = 32)) == cFlag) {
                if (!rtFlag.isEmpty()) {
                    rtFlag = rtFlag + "/";
                }
                rtFlag = rtFlag + "UART_FAIL";
            }
            return rtFlag;
        }
        return NfcTypeA.getFlagName(flag);
    }

    public ExtDevice getExtension() {
        return this.exInstance;
    }

    public void setExtension(ExtDevice instance) {
        this.exInstance = instance;
    }

    public void clearFlagsRegister() {
        this.commandsTransceive((ICommand)xCommand.CLEAR_FLAGS, Utils.parseIntegerToByteArray(255));
    }

    public byte[] receiveDataFromUART() {
        return this.commandsTransceive((ICommand)xCommand.RXUR, Utils.parseIntegerToByteArray(0));
    }

    public void clearFIFO() {
        this.autoTransceive(new byte[]{-78, 0});
    }

    public byte[] sendDataViaUART(byte[] data) {
        return this.commandsTransceive((ICommand)xCommand.TXRU, data);
    }

    public byte[][] sendDataViaUART(byte[] ... data) {
        return this.commandsTransceive((ICommand)xCommand.TXRU, data);
    }

    public byte[] getReceiveDataWithoutFlag() {
        byte[] receiveData = this.mNfcA.getReceiverData();
        if (receiveData == null || receiveData.length == 0) {
            return new byte[0];
        }
        if (receiveData.length == 2 && (this.isUARTFail() || this.isUplinkFIFOOverflow() || this.isDownlinkFIFOOverflow() || this.isUplinkFIFOEmpty())) {
            return new byte[0];
        }
        byte[] data = new byte[receiveData.length - 1];
        System.arraycopy(receiveData, 1, data, 0, data.length);
        return data;
    }

    public Byte getReceiveFlag() {
        byte[] receiveData = this.mNfcA.getReceiverData();
        if (receiveData == null || receiveData.length == 0) {
            return (byte)127;
        }
        return receiveData[0];
    }

    public byte getPowerMeasurementStatus() {
        byte[] pwr_status = this.autoTransceive(new byte[]{-75, 1});
        if (this.isSendCompleted() && pwr_status != null && pwr_status.length > 1) {
            return pwr_status[1];
        }
        return 0;
    }

    public boolean isDownlinkFIFOOverflow() {
        int flag = -127;
        return (this.mNfcA.getResponseFlag() & flag) == flag;
    }

    public boolean isUplinkFIFOEmpty() {
        int flag = -126;
        return (this.mNfcA.getResponseFlag() & flag) == flag;
    }

    public boolean isUplinkFIFOOverflow() {
        int flag = -124;
        return (this.mNfcA.getResponseFlag() & flag) == flag;
    }

    public boolean isInsufficientPowerToSourceLoad() {
        int flag = -120;
        return (this.mNfcA.getResponseFlag() & flag) == flag;
    }

    public boolean isVoltageOnXVddDrop() {
        int flag = -112;
        return (this.mNfcA.getResponseFlag() & flag) == flag;
    }

    public boolean isUARTFail() {
        int flag = -96;
        return (this.mNfcA.getResponseFlag() & flag) == flag;
    }
}

