/*
 * Decompiled with CFR 0.152.
 */
package com.sic.module.nfc.tech.chips.s4310.registers;

import com.sic.module.nfc.tech.interfaces.ILocalRegister;
import com.sic.module.nfc.tech.interfaces.IRegister;

public class PeripheralConfig
implements ILocalRegister {
    public static final byte ADDRESS = 13;
    public static final byte FACTORY_VALUE = 7;
    public static final String NAME = "Peripheral Config";
    public static final byte PW_LV_500_UA = IRegister.Bit.parseBit();
    public static final byte PW_LV_1250_UA = IRegister.Bit.parseBit(4);
    public static final byte PW_LV_2500_UA = IRegister.Bit.parseBit(5);
    public static final byte PW_LV_5000_UA = IRegister.Bit.parseBit(5, 4);
    public static final byte PWCHK_DISABLE = IRegister.Bit.parseBit();
    public static final byte PWCHK_ENABLE = IRegister.Bit.parseBit(2);
    public static final byte LDO_DISABLE = IRegister.Bit.parseBit();
    public static final byte LDO_ENABLE = IRegister.Bit.parseBit(1);
    public static final byte OSC_DISABLE = IRegister.Bit.parseBit();
    public static final byte OSC_ENABLE = IRegister.Bit.parseBit(0);

    @Override
    public IRegister.Type getType() {
        return IRegister.Type.READ_WRITE_CONFIG;
    }

    @Override
    public String getDescription(IRegister.Bit bit) {
        switch (bit) {
            case BIT_5: 
            case BIT_4: {
                return "PW_LV defines threshold power level received from coil to turn on LDO for driving external load on XVDD.\n\t00: 500 uA\n\t01: 1.25 mA\n\t10: 2.50 mA\n\t11: 5.00 mA";
            }
            case BIT_2: {
                return "PWCHK_EN enable qualifying process before turning on the on-chip LDO.\n\t0: Disable ( on-chip LDO is turned on immediately when LDO_EN is set to '1' without qualifying process and RSPW_RDY is always be '1')\n\t1: Enable";
            }
            case BIT_1: {
                return "LDO_EN enable the on-chip LDO Regulator\n\t0: Disable LDO\n\t1: Enable LDO";
            }
            case BIT_0: {
                return "OSC_EN enable on-chip oscillator for UART communication.\n\t0: Disable on-chip oscillator\n\t1: Enable on-chip oscillator";
            }
        }
        return "RFU";
    }

    @Override
    public byte getAddress() {
        return 13;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public byte getFactoryValue() {
        return 7;
    }

    public static class Params {
        public static final byte PW_LV = IRegister.Bit.parseBit(5, 4);
        public static final byte PWCHK_EN = IRegister.Bit.parseBit(2);
        public static final byte LDO_EN = IRegister.Bit.parseBit(1);
        public static final byte OSC_EN = IRegister.Bit.parseBit(0);
    }
}

