/*
 * Decompiled with CFR 0.152.
 */
package com.sic.module.nfc.tech.chips.s4310;

import com.sic.module.nfc.tech.chips.s4310.GPIO;
import com.sic.module.nfc.tech.chips.s4310.Register;
import com.sic.module.nfc.tech.chips.s431x.SIC431x;
import com.sic.module.nfc.tech.chips.s431x.xCommand;
import com.sic.module.nfc.tech.interfaces.ICommand;
import com.sic.module.utils.Utils;

public class UART {
    public static final int SPEED_OF_UART = 1843200;
    public static final byte UART_CONFIG_STOP_BIT = 8;
    public static final byte UART_CONFIG_PARITY_BIT = 7;
    public static final byte UART_STOP_BIT_1 = 0;
    public static final byte UART_STOP_BIT_2 = 8;
    public static final byte UART_PARITY_BIT_NONE = 0;
    public static final byte UART_PARITY_BIT_SPACE = 4;
    public static final byte UART_PARITY_BIT_MARK = 5;
    public static final byte UART_PARITY_BIT_EVEN = 6;
    public static final byte UART_PARITY_BIT_ODD = 7;
    public static final int FLAG_ERR_CODE_UCMD = 126;
    public static final int ERR_IO_CONTROL_DONE = 21;
    public static final int ERR_IO_CONTROL_FAILED = 26;
    public static final int ERR_EINK_SET_TEXT_DONE = 37;
    public static final int ERR_EINK_SET_CLOCK_DONE = 38;
    public static final int ERR_EINK_SET_DOWNCOUNT_TIMER_DONE = 39;
    public static final int ERR_EINK_SET_TEXT_FAILED = 42;
    public static final int ERR_EINK_SET_CLOCK_FAILED = 43;
    public static final int ERR_EINK_SET_DOWNCOUNT_TIMER_FAILED = 44;
    public static final int ERR_WRITE_DONE = 53;
    public static final int ERR_WRITE_FAILED = 58;
    public static final int ERR_TRANSFER_VIA_UHF_DONE = 69;
    public static final int ERR_TRANSFER_VIA_UHF_FAILED = 74;
    public static final int ERR_READ_RETURNS_VALUES = 85;
    public static final int ERR_READ_FAILED = 90;
    public static final int ERR_UNKNOWN_ERROR = 250;
    private static UART instance;
    private GPIO mGPIO = GPIO.getInstance();
    private Register mRegister = Register.getInstance();
    private int bitRate;
    private byte stopBits;
    private byte parity;
    private byte mode;

    private UART() {
    }

    public static UART getInstance() {
        if (instance == null) {
            instance = new UART();
        }
        return instance;
    }

    public void initUART() {
        this.initUART(115200, (byte)0, (byte)0, (byte)(GPIO.PIN_UART_TX | GPIO.PIN_UART_RX));
    }

    public void initUART(int bitRate) {
        this.initUART(bitRate, (byte)0, (byte)0, (byte)(GPIO.PIN_UART_TX | GPIO.PIN_UART_RX));
    }

    public void initUART(int bitRate, byte stopBits, byte parity, byte mode) {
        try {
            int n;
            this.bitRate = bitRate;
            this.stopBits = stopBits;
            this.parity = parity;
            this.mode = mode;
            int UARTRateDiv = 1843200 / bitRate;
            int m = 1;
            for (n = UARTRateDiv; n > 48; n >>= 1) {
                m <<= 1;
            }
            byte[][] buffer = new byte[][]{{4, (byte)(stopBits | parity)}, {5, (byte)m}, {6, (byte)n}, {9, (byte)(mode | this.mGPIO.getMode())}, {8, (byte)(~GPIO.PIN_UART_RX & (GPIO.PIN_UART_TX | this.mGPIO.getDirection()))}};
            this.mRegister.write(buffer);
        }
        catch (Exception e) {
            e.getStackTrace();
        }
    }

    public int getBitRate() {
        return this.bitRate;
    }

    public void setBitRate(int baudRate) {
        this.bitRate = baudRate;
    }

    public byte getStopBits() {
        return this.stopBits;
    }

    public void setStopBits(byte stopBits) {
        this.stopBits = stopBits;
    }

    public byte getParity() {
        return this.parity;
    }

    public void setParity(byte parity) {
        this.parity = parity;
    }

    public byte getMode() {
        return this.mode;
    }

    public void setMode(byte mode) {
        this.mode = mode;
    }

    public byte[] receive() {
        return SIC431x.getInstance().commandsTransceive((ICommand)xCommand.RXUR, Utils.parseIntegerToByteArray(0));
    }

    public byte[] send(byte[] data) {
        return SIC431x.getInstance().commandsTransceive((ICommand)xCommand.TXRU, data);
    }
}

