/*
 * Decompiled with CFR 0.152.
 */
package com.sic.module.nfc.tech.chips;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.nfc.tech.Ndef;
import android.nfc.tech.NfcA;
import com.sic.module.nfc.tech.interfaces.ICommand;
import com.sic.module.nfc.tech.mandatories.NfcTypeA;
import com.sic.module.nfc.tech.optionals.NfcTypeNdef;
import com.sic.module.utils.SICLog;

public class SIC43xx {
    private static final String TAG = SIC43xx.class.getName();
    private static SIC43xx instance;
    protected NfcTypeA mNfcA;
    protected NfcTypeNdef mNdef;

    protected SIC43xx(Context context) {
        SICLog.i(TAG, "SIC43xx is supported NFC Type A and NDEF format");
        this.mNfcA = NfcTypeA.getInstance(context);
        this.mNdef = NfcTypeNdef.getInstance(context);
    }

    public static SIC43xx getInstance(Context context) {
        if (instance == null) {
            instance = new SIC43xx(context);
        }
        return instance;
    }

    public void onResume(Activity activity) {
        this.mNfcA.onResume(activity);
    }

    public void onPause(Activity activity) {
        this.mNfcA.onPause(activity);
    }

    public boolean onTagFinding(Intent intent) {
        boolean found = false;
        if (this.mNfcA.onTagFinding(intent)) {
            this.mNdef.onTagFinding(this.mNfcA.getTag());
            found = true;
        }
        return found;
    }

    public void requestTag() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SIC43xx.this.mNfcA.setTimeout(100);
                    SIC43xx.this.mNfcA.connect();
                    SIC43xx.this.mNfcA.transceive(new byte[]{-74, 3, -1});
                    SIC43xx.this.mNfcA.transceive(new byte[]{-77, 0});
                    SIC43xx.this.mNfcA.transceive(new byte[]{-80});
                    SIC43xx.this.mNfcA.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    public byte[] autoTransceive(byte[] send_data) {
        return this.mNfcA.autoTransceive(send_data);
    }

    public byte[][] autoTransceive(byte[] ... send_data) {
        return this.mNfcA.autoTransceive(send_data);
    }

    public boolean isSendCompleted() {
        return this.mNfcA.getResponseFlag() != 125 && this.mNfcA.isSendCompleted();
    }

    public byte[] commandsTransceive(ICommand command, byte[] data) {
        return this.mNfcA.commandTransceive(command, data);
    }

    public byte[][] commandsTransceive(ICommand command, byte[] ... data) {
        return this.mNfcA.commandTransceive(command, data);
    }

    public boolean isTagAlive() {
        this.mNfcA.isNfcTag();
        return this.isSendCompleted();
    }

    public int getTimeout() {
        return this.mNfcA.getTimeout();
    }

    public void setTimeout(int timeout) {
        this.mNfcA.setTimeout(timeout);
    }

    public NfcTypeNdef getNdef() {
        return this.mNdef;
    }

    public NfcA getRawNfcA() {
        return this.mNfcA.getRawNfcA();
    }

    public Ndef getRawNdef() {
        return this.mNdef.getRawNdef();
    }

    public byte[] getUID() {
        return this.mNfcA.getUID();
    }
}

