/*
 * Decompiled with CFR 0.152.
 */
package com.shuyu.gsyvideoplayer.video;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.danikula.videocache.HttpProxyCacheServer;
import com.shuyu.gsyvideoplayer.GSYVideoADManager;
import com.shuyu.gsyvideoplayer.R;
import com.shuyu.gsyvideoplayer.utils.CommonUtil;
import com.shuyu.gsyvideoplayer.video.StandardGSYVideoPlayer;
import com.shuyu.gsyvideoplayer.video.base.GSYBaseVideoPlayer;
import com.shuyu.gsyvideoplayer.video.base.GSYVideoViewBridge;
import java.io.File;
import tv.danmaku.ijk.media.player.IjkLibLoader;

public class GSYADVideoPlayer
extends StandardGSYVideoPlayer {
    protected View mJumpAd;
    protected TextView mADTime;
    protected boolean isFirstPrepared;

    public GSYADVideoPlayer(Context context, Boolean fullFlag) {
        super(context, fullFlag);
    }

    public GSYADVideoPlayer(Context context) {
        super(context);
    }

    public GSYADVideoPlayer(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    protected void init(Context context) {
        super.init(context);
        this.mJumpAd = this.findViewById(R.id.jump_ad);
        this.mADTime = (TextView)this.findViewById(R.id.ad_time);
        if (this.mJumpAd != null) {
            this.mJumpAd.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (GSYADVideoPlayer.this.getGSYVideoManager().listener() != null) {
                        GSYADVideoPlayer.this.getGSYVideoManager().listener().onAutoCompletion();
                    }
                }
            });
        }
    }

    @Override
    public int getLayoutId() {
        return R.layout.video_layout_ad;
    }

    @Override
    public void setIjkLibLoader(IjkLibLoader libLoader) {
        GSYVideoADManager.setIjkLibLoader(libLoader);
    }

    @Override
    public GSYVideoViewBridge getGSYVideoManager() {
        return GSYVideoADManager.instance();
    }

    @Override
    protected boolean backFromFull(Context context) {
        return GSYVideoADManager.backFromWindowFull(context);
    }

    @Override
    protected void releaseVideos() {
        GSYVideoADManager.releaseAllVideos();
    }

    @Override
    protected HttpProxyCacheServer getProxy(Context context, File file) {
        return GSYVideoADManager.getProxy(context, file);
    }

    @Override
    protected int getFullId() {
        return GSYVideoADManager.FULLSCREEN_ID;
    }

    @Override
    protected int getSmallId() {
        return GSYVideoADManager.SMALL_ID;
    }

    @Override
    public void onPrepared() {
        super.onPrepared();
        this.isFirstPrepared = true;
        this.changeAdUIState();
    }

    @Override
    public void onClick(View v) {
        if (v.getId() == R.id.start) {
            if (this.mCurrentState == 7) {
                this.clickStartIcon();
            }
        } else {
            super.onClick(v);
        }
    }

    @Override
    protected void updateStartImage() {
        if (this.mStartButton != null && this.mStartButton instanceof ImageView) {
            ImageView imageView = (ImageView)this.mStartButton;
            if (this.mCurrentState == 2) {
                imageView.setImageResource(R.drawable.empty_drawable);
            } else if (this.mCurrentState == 7) {
                imageView.setImageResource(R.drawable.video_click_error_selector);
            } else {
                imageView.setImageResource(R.drawable.empty_drawable);
            }
        }
    }

    @Override
    protected void touchDoubleUp() {
    }

    @Override
    protected void touchSurfaceMove(float deltaX, float deltaY, float y) {
        if (!this.mChangePosition) {
            super.touchSurfaceMove(deltaX, deltaY, y);
        }
    }

    @Override
    protected void touchSurfaceMoveFullLogic(float absDeltaX, float absDeltaY) {
        if (absDeltaX > (float)this.mThreshold || absDeltaY > (float)this.mThreshold) {
            int screenWidth = CommonUtil.getScreenWidth(this.getContext());
            if (absDeltaX >= (float)this.mThreshold && Math.abs((float)screenWidth - this.mDownX) > (float)this.mSeekEndOffset) {
                this.mChangePosition = true;
                this.mDownPosition = this.getCurrentPositionWhenPlaying();
            } else {
                super.touchSurfaceMoveFullLogic(absDeltaX, absDeltaY);
            }
        }
    }

    @Override
    protected void touchSurfaceUp() {
        if (this.mChangePosition) {
            return;
        }
        super.touchSurfaceUp();
    }

    @Override
    protected void hideAllWidget() {
        if (this.isFirstPrepared) {
            return;
        }
        super.hideAllWidget();
    }

    @Override
    protected void setProgressAndTime(int progress, int secProgress, int currentTime, int totalTime) {
        super.setProgressAndTime(progress, secProgress, currentTime, totalTime);
        if (this.mADTime != null && currentTime > 0) {
            int totalSeconds = totalTime / 1000;
            int currentSeconds = currentTime / 1000;
            this.mADTime.setText((CharSequence)("" + (totalSeconds - currentSeconds)));
        }
    }

    @Override
    protected void cloneParams(GSYBaseVideoPlayer from, GSYBaseVideoPlayer to) {
        super.cloneParams(from, to);
        GSYADVideoPlayer sf = (GSYADVideoPlayer)from;
        GSYADVideoPlayer st = (GSYADVideoPlayer)to;
        st.isFirstPrepared = sf.isFirstPrepared;
        st.changeAdUIState();
    }

    @Override
    public void release() {
        super.release();
        if (this.mADTime != null) {
            this.mADTime.setVisibility(8);
        }
    }

    protected void changeAdUIState() {
        if (this.mJumpAd != null) {
            this.mJumpAd.setVisibility(this.isFirstPrepared ? 0 : 8);
        }
        if (this.mADTime != null) {
            this.mADTime.setVisibility(this.isFirstPrepared ? 0 : 8);
        }
        if (this.mBottomContainer != null) {
            int color2 = this.isFirstPrepared ? 0 : this.getContext().getResources().getColor(R.color.bottom_container_bg);
            this.mBottomContainer.setBackgroundColor(color2);
        }
        if (this.mCurrentTimeTextView != null) {
            this.mCurrentTimeTextView.setVisibility(this.isFirstPrepared ? 4 : 0);
        }
        if (this.mTotalTimeTextView != null) {
            this.mTotalTimeTextView.setVisibility(this.isFirstPrepared ? 4 : 0);
        }
        if (this.mProgressBar != null) {
            this.mProgressBar.setVisibility(this.isFirstPrepared ? 4 : 0);
            this.mProgressBar.setEnabled(!this.isFirstPrepared);
        }
    }

    public void removeFullWindowViewOnly() {
        ViewGroup vp = (ViewGroup)CommonUtil.scanForActivity(this.getContext()).findViewById(0x1020002);
        View old = vp.findViewById(this.getFullId());
        if (old != null && old.getParent() != null) {
            ViewGroup viewGroup = (ViewGroup)old.getParent();
            vp.removeView((View)viewGroup);
        }
        this.mIfCurrentIsFullscreen = false;
    }
}

