/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.zoomlayout;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import com.shopgun.android.utils.UnitUtils;
import java.util.Locale;

public class ZoomUtils {
    private static final String MATRIX_BACIS_FORMAT = "[ scale:%.2f, x:%.0f, y:%.0f ]";
    private static final String MATRIX_FORMAT = "[ %.2f, %.2f, %.2f ][ %.2f, %.2f, %.2f ][ %.2f, %.2f, %.2f ]";
    private static final float[] v = new float[9];
    private static final String RECT_FORMAT = "%s: %s [ %.0f, %.0f, %.0f, %.0f ], w:%s, h:%s";
    private static Paint mDebugPaintBlue;
    private static Paint mDebugPaintWhite;
    private static Paint mDebugPaintYellow;
    private static Paint mDebugPaintRed;
    private static int mDebugRadius;

    private ZoomUtils() {
    }

    public static String getMatrixBasicInfo(Matrix m) {
        m.getValues(v);
        return String.format(Locale.US, MATRIX_BACIS_FORMAT, Float.valueOf(v[0]), Float.valueOf(v[2]), Float.valueOf(v[5]));
    }

    public static String getMatrixInfo(Matrix m) {
        m.getValues(v);
        return String.format(Locale.US, MATRIX_FORMAT, Float.valueOf(v[0]), Float.valueOf(v[1]), Float.valueOf(v[2]), Float.valueOf(v[3]), Float.valueOf(v[4]), Float.valueOf(v[5]), Float.valueOf(v[6]), Float.valueOf(v[7]), Float.valueOf(v[8]));
    }

    public static String getViewRectInfo(String tag, String name, RectF r) {
        return String.format(Locale.US, RECT_FORMAT, tag, name, Float.valueOf(r.left), Float.valueOf(r.top), Float.valueOf(r.right), Float.valueOf(r.bottom), Float.valueOf(r.width()), Float.valueOf(r.height()));
    }

    private static void ensureDebugOptions(Context context) {
        if (mDebugPaintBlue == null) {
            mDebugPaintWhite = new Paint();
            mDebugPaintWhite.setColor(-1);
            mDebugPaintBlue = new Paint();
            mDebugPaintBlue.setColor(-16776961);
            mDebugPaintYellow = new Paint();
            mDebugPaintYellow.setColor(-256);
            mDebugPaintRed = new Paint();
            mDebugPaintRed.setColor(-65536);
            mDebugRadius = UnitUtils.dpToPx((int)4, (Context)context);
        }
    }

    public static void debugDraw(Canvas canvas, Context context, float tx, float ty, float fx, float fy, float invScale) {
        ZoomUtils.ensureDebugOptions(context);
        int r = (int)((float)mDebugRadius * invScale);
        ZoomUtils.debugDrawCirc(canvas, tx, ty, r, mDebugPaintBlue);
        ZoomUtils.debugDrawCirc(canvas, 0.0f, 0.0f, r, mDebugPaintRed);
        ZoomUtils.debugDrawCirc(canvas, fx, fy, r, mDebugPaintYellow);
    }

    private static void debugDrawCirc(Canvas canvas, float cx, float cy, int r, Paint p) {
        canvas.drawCircle(cx, cy, (float)r, mDebugPaintWhite);
        canvas.drawCircle(cx, cy, (float)(r / 2), p);
    }

    public static void setRect(Rect rect, float[] array) {
        ZoomUtils.setRect(rect, array[0], array[1], array[2], array[3]);
    }

    public static void setRect(RectF rect, float[] array) {
        ZoomUtils.setRect(rect, array[0], array[1], array[2], array[3]);
    }

    public static void setRect(RectF rect, float l, float t, float r, float b) {
        rect.set((float)Math.round(l), (float)Math.round(t), (float)Math.round(r), (float)Math.round(b));
    }

    public static void setRect(Rect rect, float l, float t, float r, float b) {
        rect.set(Math.round(l), Math.round(t), Math.round(r), Math.round(b));
    }

    public static void setArray(float[] array, Rect rect) {
        array[0] = rect.left;
        array[1] = rect.top;
        array[2] = rect.right;
        array[3] = rect.bottom;
    }

    public static void setArray(float[] array, RectF rect) {
        array[0] = rect.left;
        array[1] = rect.top;
        array[2] = rect.right;
        array[3] = rect.bottom;
    }

    static {
        mDebugRadius = 0;
    }
}

