/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.zoomlayout;

import com.shopgun.android.zoomlayout.ZoomLayout;

public class ZoomOnDoubleTapListener
implements ZoomLayout.OnDoubleTapListener {
    private boolean mThreeStep = false;

    public ZoomOnDoubleTapListener(boolean threeStep) {
        this.mThreeStep = threeStep;
    }

    @Override
    public boolean onDoubleTap(ZoomLayout view, ZoomLayout.TapInfo info) {
        try {
            if (this.mThreeStep) {
                this.threeStep(view, info.getX(), info.getY());
            } else {
                this.twoStep(view, info.getX(), info.getY());
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return true;
    }

    private void twoStep(ZoomLayout view, float x, float y) {
        if (view.getScale() > view.getMinScale()) {
            view.setScale(view.getMinScale(), true);
        } else {
            view.setScale(view.getMaxScale(), x, y, true);
        }
    }

    private void threeStep(ZoomLayout view, float x, float y) {
        float medium;
        float scale = view.getScale();
        if (scale < (medium = view.getMinScale() + (view.getMaxScale() - view.getMinScale()) * 0.3f)) {
            view.setScale(medium, x, y, true);
        } else if (scale >= medium && scale < view.getMaxScale()) {
            view.setScale(view.getMaxScale(), x, y, true);
        } else {
            view.setScale(view.getMinScale(), true);
        }
    }
}

