/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.zoomlayout;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Build;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.FrameLayout;
import androidx.core.view.ViewCompat;
import com.shopgun.android.utils.NumberUtils;
import com.shopgun.android.utils.log.L;
import com.shopgun.android.zoomlayout.ScrollerCompat;
import com.shopgun.android.zoomlayout.ZoomUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class ZoomLayout
extends FrameLayout {
    public static final String TAG = ZoomLayout.class.getSimpleName();
    private static final int DEF_ZOOM_DURATION = 250;
    public boolean DEBUG = false;
    private ScaleGestureDetector mScaleDetector;
    private GestureDetector mGestureDetector;
    private GestureListener mGestureListener;
    private SimpleOnGlobalLayoutChangedListener mSimpleOnGlobalLayoutChangedListener;
    private Matrix mScaleMatrix = new Matrix();
    private Matrix mScaleMatrixInverse = new Matrix();
    private Matrix mTranslateMatrix = new Matrix();
    private Matrix mTranslateMatrixInverse = new Matrix();
    private float[] mMatrixValues = new float[9];
    private float mFocusY;
    private float mFocusX;
    private float[] mArray = new float[6];
    private boolean mAllowOverScale = true;
    RectF mDrawRect = new RectF();
    RectF mViewPortRect = new RectF();
    private FlingRunnable mFlingRunnable;
    private AnimatedZoomRunnable mAnimatedZoomRunnable;
    private Interpolator mAnimationInterpolator = new DecelerateInterpolator();
    private int mZoomDuration = 250;
    boolean mAllowParentInterceptOnEdge = true;
    boolean mAllowParentInterceptOnScaled = false;
    private float mMinScale = 1.0f;
    private float mMaxScale = 3.0f;
    private boolean mAllowZoom = true;
    private ZoomDispatcher mZoomDispatcher = new ZoomDispatcher();
    private PanDispatcher mPanDispatcher = new PanDispatcher();
    private List<OnZoomListener> mOnZoomListeners;
    private List<OnPanListener> mOnPanListeners;
    private List<OnTouchListener> mOnTouchListeners;
    private List<OnTapListener> mOnTapListeners;
    private List<OnDoubleTapListener> mOnDoubleTapListeners;
    private List<OnLongTapListener> mOnLongTapListeners;

    public ZoomLayout(Context context) {
        super(context);
        this.init(context, null);
    }

    public ZoomLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public ZoomLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public ZoomLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.mGestureListener = new GestureListener();
        this.mScaleDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)this.mGestureListener);
        if (Build.VERSION.SDK_INT > 19) {
            this.mScaleDetector.setQuickScaleEnabled(false);
        }
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)this.mGestureListener);
        this.mSimpleOnGlobalLayoutChangedListener = new SimpleOnGlobalLayoutChangedListener();
        this.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this.mSimpleOnGlobalLayoutChangedListener);
    }

    protected void onDetachedFromWindow() {
        ZoomLayout.removeGlobal((View)this, this.mSimpleOnGlobalLayoutChangedListener);
        super.onDetachedFromWindow();
    }

    public static void removeGlobal(View v, ViewTreeObserver.OnGlobalLayoutListener listener) {
        ViewTreeObserver obs = v.getViewTreeObserver();
        if (Build.VERSION.SDK_INT >= 16) {
            obs.removeOnGlobalLayoutListener(listener);
        } else {
            obs.removeGlobalOnLayoutListener(listener);
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        canvas.save();
        canvas.translate(-this.getPosX(), -this.getPosY());
        float scale = this.getScale();
        canvas.scale(scale, scale, this.mFocusX, this.mFocusY);
        try {
            super.dispatchDraw(canvas);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.DEBUG) {
            ZoomUtils.debugDraw(canvas, this.getContext(), this.getPosX(), this.getPosY(), this.mFocusX, this.mFocusY, this.getMatrixValue(this.mScaleMatrixInverse, 0));
        }
        canvas.restore();
    }

    public ViewParent invalidateChildInParent(int[] location, Rect dirty) {
        this.scaledPointsToScreenPoints(dirty);
        float scale = this.getScale();
        location[0] = (int)((float)location[0] * scale);
        location[1] = (int)((float)location[1] * scale);
        return super.invalidateChildInParent(location, dirty);
    }

    private void scaledPointsToScreenPoints(Rect rect) {
        ZoomUtils.setArray(this.mArray, rect);
        this.mArray = this.scaledPointsToScreenPoints(this.mArray);
        ZoomUtils.setRect(rect, this.mArray);
    }

    private void scaledPointsToScreenPoints(RectF rect) {
        ZoomUtils.setArray(this.mArray, rect);
        this.mArray = this.scaledPointsToScreenPoints(this.mArray);
        ZoomUtils.setRect(rect, this.mArray);
    }

    private float[] scaledPointsToScreenPoints(float[] a) {
        this.mScaleMatrix.mapPoints(a);
        this.mTranslateMatrix.mapPoints(a);
        return a;
    }

    private float[] screenPointsToScaledPoints(float[] a) {
        this.mTranslateMatrixInverse.mapPoints(a);
        this.mScaleMatrixInverse.mapPoints(a);
        return a;
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        this.mArray[0] = ev.getX();
        this.mArray[1] = ev.getY();
        this.screenPointsToScaledPoints(this.mArray);
        ev.setLocation(this.mArray[0], this.mArray[1]);
        return super.dispatchTouchEvent(ev);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return this.mAllowZoom;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        this.mArray[0] = ev.getX();
        this.mArray[1] = ev.getY();
        this.scaledPointsToScreenPoints(this.mArray);
        ev.setLocation(this.mArray[0], this.mArray[1]);
        if (!this.mAllowZoom) {
            return false;
        }
        int action = ev.getAction() & 0xFF;
        this.dispatchOnTouch(action, ev);
        boolean consumed = this.mScaleDetector.onTouchEvent(ev);
        boolean bl = consumed = this.mGestureDetector.onTouchEvent(ev) || consumed;
        if (action == 1) {
            consumed = this.mGestureListener.onUp(ev) || consumed;
        }
        return consumed;
    }

    private void fixFocusPoint(float focusX, float focusY) {
        this.mArray[0] = focusX;
        this.mArray[1] = focusY;
        this.screenPointsToScaledPoints(this.mArray);
        float x1 = this.getMatrixValue(this.mScaleMatrix, 2);
        float y1 = this.getMatrixValue(this.mScaleMatrix, 5);
        this.internalScale(this.getScale(), this.mArray[0], this.mArray[1]);
        float dX = this.getMatrixValue(this.mScaleMatrix, 2) - x1;
        float dY = this.getMatrixValue(this.mScaleMatrix, 5) - y1;
        this.internalMove(dX + this.getPosX(), dY + this.getPosY(), false);
    }

    private void cancelFling() {
        if (this.mFlingRunnable != null) {
            this.mFlingRunnable.cancelFling();
            this.mFlingRunnable = null;
        }
    }

    private void cancelZoom() {
        if (this.mAnimatedZoomRunnable != null) {
            this.mAnimatedZoomRunnable.cancel();
            this.mAnimatedZoomRunnable = null;
        }
    }

    public RectF getDrawRect() {
        return new RectF(this.mDrawRect);
    }

    public boolean isAllowOverScale() {
        return this.mAllowOverScale;
    }

    public void setAllowOverScale(boolean allowOverScale) {
        this.mAllowOverScale = allowOverScale;
    }

    public boolean isAllowParentInterceptOnEdge() {
        return this.mAllowParentInterceptOnEdge;
    }

    public void setAllowParentInterceptOnEdge(boolean allowParentInterceptOnEdge) {
        this.mAllowParentInterceptOnEdge = allowParentInterceptOnEdge;
    }

    public boolean isAllowParentInterceptOnScaled() {
        return this.mAllowParentInterceptOnScaled;
    }

    public void setAllowParentInterceptOnScaled(boolean allowParentInterceptOnScaled) {
        this.mAllowParentInterceptOnScaled = allowParentInterceptOnScaled;
    }

    public int getZoomDuration() {
        return this.mZoomDuration;
    }

    public void setZoomDuration(int zoomDuration) {
        this.mZoomDuration = zoomDuration < 0 ? 250 : zoomDuration;
    }

    public void setZoomInterpolator(Interpolator zoomAnimationInterpolator) {
        this.mAnimationInterpolator = zoomAnimationInterpolator;
    }

    public float getMaxScale() {
        return this.mMaxScale;
    }

    public void setMaxScale(float maxScale) {
        this.mMaxScale = maxScale;
        if (this.mMaxScale < this.mMinScale) {
            this.setMinScale(maxScale);
        }
    }

    public float getMinScale() {
        return this.mMinScale;
    }

    public void setMinScale(float minScale) {
        this.mMinScale = minScale;
        if (this.mMinScale > this.mMaxScale) {
            this.setMaxScale(this.mMinScale);
        }
    }

    public boolean isAllowZoom() {
        return this.mAllowZoom;
    }

    public void setAllowZoom(boolean allowZoom) {
        this.mAllowZoom = allowZoom;
    }

    public float getScale() {
        return this.getMatrixValue(this.mScaleMatrix, 0);
    }

    public void setScale(float scale) {
        this.setScale(scale, true);
    }

    public void setScale(float scale, boolean animate) {
        View c = this.getChildAt(0);
        this.setScale(scale, this.getRight() / 2, this.getBottom() / 2, animate);
    }

    public boolean isTranslating() {
        return this.mGestureListener.mScrolling;
    }

    public boolean isScaling() {
        return this.mScaleDetector.isInProgress();
    }

    public boolean isScaled() {
        return !NumberUtils.isEqual((float)this.getScale(), (float)1.0f, (float)0.05f);
    }

    public void setScale(float scale, float focusX, float focusY, boolean animate) {
        if (!this.mAllowZoom) {
            return;
        }
        this.fixFocusPoint(focusX, focusY);
        if (!this.mAllowOverScale) {
            scale = NumberUtils.clamp((float)this.mMinScale, (float)scale, (float)this.mMaxScale);
        }
        if (animate) {
            this.mAnimatedZoomRunnable = new AnimatedZoomRunnable();
            this.mAnimatedZoomRunnable.scale(this.getScale(), scale, this.mFocusX, this.mFocusY, true);
            ViewCompat.postOnAnimation((View)this, (Runnable)this.mAnimatedZoomRunnable);
        } else {
            this.mZoomDispatcher.onZoomBegin(this.getScale());
            this.internalScale(scale, this.mFocusX, this.mFocusY);
            this.mZoomDispatcher.onZoom(scale);
            this.mZoomDispatcher.onZoomEnd(scale);
        }
    }

    public boolean moveBy(float dX, float dY) {
        return this.moveTo(dX + this.getPosX(), dY + this.getPosY());
    }

    public boolean moveTo(float posX, float posY) {
        this.mPanDispatcher.onPanBegin();
        if (this.internalMove(posX, posY, true)) {
            this.mPanDispatcher.onPan();
        }
        this.mPanDispatcher.onPanEnd();
        return true;
    }

    private boolean internalMoveBy(float dx, float dy, boolean clamp) {
        float tdx = dx;
        float tdy = dy;
        if (clamp) {
            RectF bounds = this.getTranslateDeltaBounds();
            tdx = NumberUtils.clamp((float)bounds.left, (float)dx, (float)bounds.right);
            tdy = NumberUtils.clamp((float)bounds.top, (float)dy, (float)bounds.bottom);
        }
        float posX = tdx + this.getPosX();
        float posY = tdy + this.getPosY();
        if (!NumberUtils.isEqual((float)posX, (float)this.getPosX()) || !NumberUtils.isEqual((float)posY, (float)this.getPosY())) {
            this.mTranslateMatrix.setTranslate(-posX, -posY);
            this.matrixUpdated();
            this.invalidate();
            return true;
        }
        return false;
    }

    private boolean internalMove(float posX, float posY, boolean clamp) {
        return this.internalMoveBy(posX - this.getPosX(), posY - this.getPosY(), clamp);
    }

    private RectF getTranslateDeltaBounds() {
        RectF r = new RectF();
        float maxDeltaX = this.mDrawRect.width() - this.mViewPortRect.width();
        if (maxDeltaX < 0.0f) {
            float leftEdge = Math.round((this.mViewPortRect.width() - this.mDrawRect.width()) / 2.0f);
            if (leftEdge > this.mDrawRect.left) {
                r.left = 0.0f;
                r.right = leftEdge - this.mDrawRect.left;
            } else {
                r.left = leftEdge - this.mDrawRect.left;
                r.right = 0.0f;
            }
        } else {
            r.left = this.mDrawRect.left - this.mViewPortRect.left;
            r.right = r.left + maxDeltaX;
        }
        float maxDeltaY = this.mDrawRect.height() - this.mViewPortRect.height();
        if (maxDeltaY < 0.0f) {
            float topEdge = Math.round((this.mViewPortRect.height() - this.mDrawRect.height()) / 2.0f);
            if (topEdge > this.mDrawRect.top) {
                r.top = this.mDrawRect.top - topEdge;
                r.bottom = 0.0f;
            } else {
                r.top = topEdge - this.mDrawRect.top;
                r.bottom = 0.0f;
            }
        } else {
            r.top = this.mDrawRect.top - this.mViewPortRect.top;
            r.bottom = r.top + maxDeltaY;
        }
        return r;
    }

    private PointF getClosestValidTranslationPoint() {
        PointF p = new PointF(this.getPosX(), this.getPosY());
        if (this.mDrawRect.width() < this.mViewPortRect.width()) {
            p.x += this.mDrawRect.centerX() - this.mViewPortRect.centerX();
        } else if (this.mDrawRect.right < this.mViewPortRect.right) {
            p.x += this.mDrawRect.right - this.mViewPortRect.right;
        } else if (this.mDrawRect.left > this.mViewPortRect.left) {
            p.x += this.mDrawRect.left - this.mViewPortRect.left;
        }
        if (this.mDrawRect.height() < this.mViewPortRect.height()) {
            p.y += this.mDrawRect.centerY() - this.mViewPortRect.centerY();
        } else if (this.mDrawRect.bottom < this.mViewPortRect.bottom) {
            p.y += this.mDrawRect.bottom - this.mViewPortRect.bottom;
        } else if (this.mDrawRect.top > this.mViewPortRect.top) {
            p.y += this.mDrawRect.top - this.mViewPortRect.top;
        }
        return p;
    }

    private void internalScale(float scale, float focusX, float focusY) {
        this.mFocusX = focusX;
        this.mFocusY = focusY;
        this.mScaleMatrix.setScale(scale, scale, this.mFocusX, this.mFocusY);
        this.matrixUpdated();
        this.requestLayout();
        this.invalidate();
    }

    private void matrixUpdated() {
        this.mScaleMatrix.invert(this.mScaleMatrixInverse);
        this.mTranslateMatrix.invert(this.mTranslateMatrixInverse);
        ZoomUtils.setRect(this.mViewPortRect, 0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
        View child = this.getChildAt(0);
        if (child != null) {
            ZoomUtils.setRect(this.mDrawRect, (float)child.getLeft(), (float)child.getTop(), (float)child.getRight(), (float)child.getBottom());
            this.scaledPointsToScreenPoints(this.mDrawRect);
        } else {
            float x = this.mViewPortRect.centerX();
            float y = this.mViewPortRect.centerY();
            this.mDrawRect.set(x, y, x, y);
        }
    }

    public float getPosX() {
        return -this.getMatrixValue(this.mTranslateMatrix, 2);
    }

    public float getPosY() {
        return -this.getMatrixValue(this.mTranslateMatrix, 5);
    }

    private float getMatrixValue(Matrix matrix, int value) {
        matrix.getValues(this.mMatrixValues);
        return this.mMatrixValues[value];
    }

    public void addOnTouchListener(OnTouchListener l) {
        if (this.mOnTouchListeners == null) {
            this.mOnTouchListeners = new ArrayList<OnTouchListener>();
        }
        this.mOnTouchListeners.add(l);
    }

    public void removeOnTouchListeners(OnTouchListener listener) {
        if (this.mOnTouchListeners != null) {
            this.mOnTouchListeners.remove(listener);
        }
    }

    public void clearOnTouchListener() {
        if (this.mOnTouchListeners != null) {
            this.mOnTouchListeners.clear();
        }
    }

    private void dispatchOnTouch(int action, MotionEvent ev) {
        if (this.mOnTouchListeners != null) {
            int z = this.mOnTouchListeners.size();
            for (int i = 0; i < z; ++i) {
                OnTouchListener listener = this.mOnTouchListeners.get(i);
                if (listener == null) continue;
                listener.onTouch(this, action, new TapInfo(this, ev));
            }
        }
    }

    public void addOnTapListener(OnTapListener l) {
        if (this.mOnTapListeners == null) {
            this.mOnTapListeners = new ArrayList<OnTapListener>();
        }
        this.mOnTapListeners.add(l);
    }

    public void removeOnTouchListener(OnTapListener listener) {
        if (this.mOnTapListeners != null) {
            this.mOnTapListeners.remove(listener);
        }
    }

    public void clearOnTabListeners() {
        if (this.mOnTapListeners != null) {
            this.mOnTapListeners.clear();
        }
    }

    private void dispatchOnTab(MotionEvent ev) {
        if (this.mOnTapListeners != null) {
            int z = this.mOnTapListeners.size();
            for (int i = 0; i < z; ++i) {
                OnTapListener listener = this.mOnTapListeners.get(i);
                if (listener == null) continue;
                listener.onTap(this, new TapInfo(this, ev));
            }
        }
    }

    public void addOnDoubleTapListener(OnDoubleTapListener l) {
        if (this.mOnDoubleTapListeners == null) {
            this.mOnDoubleTapListeners = new ArrayList<OnDoubleTapListener>();
        }
        this.mOnDoubleTapListeners.add(l);
    }

    public void removeOnDoubleTapListener(OnDoubleTapListener listener) {
        if (this.mOnDoubleTapListeners != null) {
            this.mOnDoubleTapListeners.remove(listener);
        }
    }

    public void clearOnDoubleTapListeners() {
        if (this.mOnDoubleTapListeners != null) {
            this.mOnDoubleTapListeners.clear();
        }
    }

    private void dispatchOnDoubleTap(MotionEvent ev) {
        if (this.mOnDoubleTapListeners != null) {
            int z = this.mOnDoubleTapListeners.size();
            for (int i = 0; i < z; ++i) {
                OnDoubleTapListener listener = this.mOnDoubleTapListeners.get(i);
                if (listener == null) continue;
                listener.onDoubleTap(this, new TapInfo(this, ev));
            }
        }
    }

    public void addOnLongTapListener(OnLongTapListener l) {
        if (this.mOnLongTapListeners == null) {
            this.mOnLongTapListeners = new ArrayList<OnLongTapListener>();
        }
        this.mOnLongTapListeners.add(l);
    }

    public void removeOnLongTapListener(OnLongTapListener listener) {
        if (this.mOnLongTapListeners != null) {
            this.mOnLongTapListeners.remove(listener);
        }
    }

    public void clearOnLongTapListeners() {
        if (this.mOnLongTapListeners != null) {
            this.mOnLongTapListeners.clear();
        }
    }

    private void dispatchOnLongTap(MotionEvent ev) {
        if (this.mOnLongTapListeners != null) {
            int z = this.mOnLongTapListeners.size();
            for (int i = 0; i < z; ++i) {
                OnLongTapListener listener = this.mOnLongTapListeners.get(i);
                if (listener == null) continue;
                listener.onLongTap(this, new TapInfo(this, ev));
            }
        }
    }

    public void addOnZoomListener(OnZoomListener l) {
        if (this.mOnZoomListeners == null) {
            this.mOnZoomListeners = new ArrayList<OnZoomListener>();
        }
        this.mOnZoomListeners.add(l);
    }

    public void removeOnZoomListener(OnZoomListener listener) {
        if (this.mOnZoomListeners != null) {
            this.mOnZoomListeners.remove(listener);
        }
    }

    public void clearOnZoomListeners() {
        if (this.mOnZoomListeners != null) {
            this.mOnZoomListeners.clear();
        }
    }

    public void addOnPanListener(OnPanListener l) {
        if (this.mOnPanListeners == null) {
            this.mOnPanListeners = new ArrayList<OnPanListener>();
        }
        this.mOnPanListeners.add(l);
    }

    public void removeOnPanListener(OnPanListener listener) {
        if (this.mOnPanListeners != null) {
            this.mOnPanListeners.remove(listener);
        }
    }

    public void clearOnPanListeners() {
        if (this.mOnPanListeners != null) {
            this.mOnPanListeners.clear();
        }
    }

    public void setOnClickListener(View.OnClickListener l) {
        throw new IllegalStateException("Cannot set OnClickListener, please use OnTapListener.");
    }

    public void setOnLongClickListener(View.OnLongClickListener l) {
        throw new IllegalStateException("Cannot set OnLongClickListener, please use OnLongTabListener.");
    }

    public void setOnTouchListener(View.OnTouchListener l) {
        throw new IllegalStateException("Cannot set OnTouchListener.");
    }

    private void log(String msg) {
        if (this.DEBUG) {
            L.d((String)TAG, (String)msg);
        }
    }

    private void printMatrixInfo(String tag, boolean regulare, boolean inverted) {
        if (regulare) {
            this.log(String.format("%s: mScaleMatrix            %s", tag, ZoomUtils.getMatrixBasicInfo(this.mScaleMatrix)));
            this.log(String.format("%s: mTranslateMatrix        %s", tag, ZoomUtils.getMatrixBasicInfo(this.mTranslateMatrix)));
        }
        if (inverted) {
            this.log(String.format("%s: mScaleMatrixInverse     %s", tag, ZoomUtils.getMatrixBasicInfo(this.mScaleMatrixInverse)));
            this.log(String.format("%s: mTranslateMatrixInverse %s", tag, ZoomUtils.getMatrixBasicInfo(this.mTranslateMatrixInverse)));
        }
    }

    private void printViewRects(String tag) {
        this.log(ZoomUtils.getViewRectInfo(tag, "ViewRect", this.mViewPortRect));
        this.log(ZoomUtils.getViewRectInfo(tag, "DrawRect", this.mDrawRect));
    }

    private class SimpleOnGlobalLayoutChangedListener
    implements ViewTreeObserver.OnGlobalLayoutListener {
        private int mLeft;
        private int mTop;
        private int mRight;
        private int mBottom;

        private SimpleOnGlobalLayoutChangedListener() {
        }

        public void onGlobalLayout() {
            boolean changed;
            int oldL = this.mLeft;
            int oldT = this.mTop;
            int oldR = this.mRight;
            int oldB = this.mBottom;
            this.mLeft = ZoomLayout.this.getLeft();
            this.mTop = ZoomLayout.this.getTop();
            this.mRight = ZoomLayout.this.getRight();
            this.mBottom = ZoomLayout.this.getBottom();
            boolean bl = changed = oldL != this.mLeft || oldT != this.mTop || oldR != this.mRight || oldB != this.mBottom;
            if (changed) {
                ZoomLayout.this.matrixUpdated();
                PointF p = ZoomLayout.this.getClosestValidTranslationPoint();
                ZoomLayout.this.internalMove(p.x, p.y, false);
            }
        }
    }

    private class PanDispatcher {
        int mCount = 0;

        private PanDispatcher() {
        }

        void onPanBegin() {
            if (this.mCount++ == 0 && ZoomLayout.this.mOnPanListeners != null) {
                int z = ZoomLayout.this.mOnPanListeners.size();
                for (int i = 0; i < z; ++i) {
                    OnPanListener listener = (OnPanListener)ZoomLayout.this.mOnPanListeners.get(i);
                    if (listener == null) continue;
                    listener.onPanBegin(ZoomLayout.this);
                }
            }
        }

        void onPan() {
            if (ZoomLayout.this.mOnPanListeners != null) {
                int z = ZoomLayout.this.mOnPanListeners.size();
                for (int i = 0; i < z; ++i) {
                    OnPanListener listener = (OnPanListener)ZoomLayout.this.mOnPanListeners.get(i);
                    if (listener == null) continue;
                    listener.onPan(ZoomLayout.this);
                }
            }
        }

        void onPanEnd() {
            if (--this.mCount == 0 && ZoomLayout.this.mOnPanListeners != null) {
                int z = ZoomLayout.this.mOnPanListeners.size();
                for (int i = 0; i < z; ++i) {
                    OnPanListener listener = (OnPanListener)ZoomLayout.this.mOnPanListeners.get(i);
                    if (listener == null) continue;
                    listener.onPanEnd(ZoomLayout.this);
                }
            }
        }
    }

    private class ZoomDispatcher {
        int mCount = 0;

        private ZoomDispatcher() {
        }

        void onZoomBegin(float scale) {
            if (this.mCount++ == 0 && ZoomLayout.this.mOnZoomListeners != null) {
                int z = ZoomLayout.this.mOnZoomListeners.size();
                for (int i = 0; i < z; ++i) {
                    OnZoomListener listener = (OnZoomListener)ZoomLayout.this.mOnZoomListeners.get(i);
                    if (listener == null) continue;
                    listener.onZoomBegin(ZoomLayout.this, scale);
                }
            }
        }

        void onZoom(float scale) {
            if (ZoomLayout.this.mOnZoomListeners != null) {
                int z = ZoomLayout.this.mOnZoomListeners.size();
                for (int i = 0; i < z; ++i) {
                    OnZoomListener listener = (OnZoomListener)ZoomLayout.this.mOnZoomListeners.get(i);
                    if (listener == null) continue;
                    listener.onZoom(ZoomLayout.this, scale);
                }
            }
        }

        void onZoomEnd(float scale) {
            if (--this.mCount == 0 && ZoomLayout.this.mOnZoomListeners != null) {
                int z = ZoomLayout.this.mOnZoomListeners.size();
                for (int i = 0; i < z; ++i) {
                    OnZoomListener listener = (OnZoomListener)ZoomLayout.this.mOnZoomListeners.get(i);
                    if (listener == null) continue;
                    listener.onZoomEnd(ZoomLayout.this, scale);
                }
            }
        }
    }

    public static class TapInfo {
        private static final String STRING_FORMAT = "TapInfo[ absX:%.0f, absY:%.0f, relX:%.0f, relY:%.0f, percentX:%.2f, percentY:%.2f, contentClicked:%s ]";
        View mView;
        float mAbsoluteX;
        float mAbsoluteY;
        float mRelativeX;
        float mRelativeY;
        float mPercentX;
        float mPercentY;
        boolean mContentClicked;

        private TapInfo() {
        }

        private TapInfo(ZoomLayout zoomLayout, MotionEvent e) {
            this.mView = zoomLayout;
            this.mAbsoluteX = e.getX();
            this.mAbsoluteY = e.getY();
            ((ZoomLayout)zoomLayout).mArray[0] = this.mAbsoluteX;
            ((ZoomLayout)zoomLayout).mArray[1] = this.mAbsoluteY;
            zoomLayout.screenPointsToScaledPoints(zoomLayout.mArray);
            View v = zoomLayout.getChildAt(0);
            this.mRelativeX = zoomLayout.mArray[0] - (float)v.getLeft();
            this.mRelativeY = zoomLayout.mArray[1] - (float)v.getTop();
            this.mPercentX = this.mRelativeX / (float)v.getWidth();
            this.mPercentY = this.mRelativeY / (float)v.getHeight();
            this.mContentClicked = zoomLayout.mDrawRect.contains(this.mAbsoluteX, this.mAbsoluteY);
        }

        public TapInfo(View view, float x, float y, float relativeX, float relativeY, float percentX, float percentY, boolean contentClicked) {
            this.mView = view;
            this.mAbsoluteX = x;
            this.mAbsoluteY = y;
            this.mRelativeX = relativeX;
            this.mRelativeY = relativeY;
            this.mPercentX = percentX;
            this.mPercentY = percentY;
            this.mContentClicked = contentClicked;
        }

        public TapInfo(TapInfo info) {
            this(info.mView, info.mAbsoluteX, info.mAbsoluteY, info.mRelativeX, info.mRelativeY, info.mPercentX, info.mPercentY, info.mContentClicked);
        }

        public View getView() {
            return this.mView;
        }

        public float getX() {
            return this.mAbsoluteX;
        }

        public float getY() {
            return this.mAbsoluteY;
        }

        public float getRelativeX() {
            return this.mRelativeX;
        }

        public float getRelativeY() {
            return this.mRelativeY;
        }

        public float getPercentX() {
            return this.mPercentX;
        }

        public float getPercentY() {
            return this.mPercentY;
        }

        public boolean isContentClicked() {
            return this.mContentClicked;
        }

        public String toString() {
            return String.format(Locale.US, STRING_FORMAT, Float.valueOf(this.mAbsoluteX), Float.valueOf(this.mAbsoluteY), Float.valueOf(this.mRelativeX), Float.valueOf(this.mRelativeY), Float.valueOf(this.mPercentX), Float.valueOf(this.mPercentY), this.mContentClicked);
        }
    }

    public static interface OnLongTapListener {
        public void onLongTap(ZoomLayout var1, TapInfo var2);
    }

    public static interface OnDoubleTapListener {
        public boolean onDoubleTap(ZoomLayout var1, TapInfo var2);
    }

    public static interface OnTapListener {
        public boolean onTap(ZoomLayout var1, TapInfo var2);
    }

    public static interface OnTouchListener {
        public boolean onTouch(ZoomLayout var1, int var2, TapInfo var3);
    }

    public static interface OnPanListener {
        public void onPanBegin(ZoomLayout var1);

        public void onPan(ZoomLayout var1);

        public void onPanEnd(ZoomLayout var1);
    }

    public static interface OnZoomListener {
        public void onZoomBegin(ZoomLayout var1, float var2);

        public void onZoom(ZoomLayout var1, float var2);

        public void onZoomEnd(ZoomLayout var1, float var2);
    }

    private class FlingRunnable
    implements Runnable {
        private final ScrollerCompat mScroller;
        private int mCurrentX;
        private int mCurrentY;
        private boolean mFinished = false;

        FlingRunnable(Context context) {
            this.mScroller = ScrollerCompat.getScroller(context);
        }

        void fling(int velocityX, int velocityY) {
            int maxY;
            int minY;
            int maxX;
            int minX;
            int startX = Math.round(ZoomLayout.this.mViewPortRect.left);
            if (ZoomLayout.this.mViewPortRect.width() < ZoomLayout.this.mDrawRect.width()) {
                minX = Math.round(ZoomLayout.this.mDrawRect.left);
                maxX = Math.round(ZoomLayout.this.mDrawRect.width() - ZoomLayout.this.mViewPortRect.width());
            } else {
                minX = maxX = startX;
            }
            int startY = Math.round(ZoomLayout.this.mViewPortRect.top);
            if (ZoomLayout.this.mViewPortRect.height() < ZoomLayout.this.mDrawRect.height()) {
                minY = Math.round(ZoomLayout.this.mDrawRect.top);
                maxY = Math.round(ZoomLayout.this.mDrawRect.bottom - ZoomLayout.this.mViewPortRect.bottom);
            } else {
                minY = maxY = startY;
            }
            this.mCurrentX = startX;
            this.mCurrentY = startY;
            if (startX != maxX || startY != maxY) {
                this.mScroller.fling(startX, startY, velocityX, velocityY, minX, maxX, minY, maxY, 0, 0);
                ZoomLayout.this.mPanDispatcher.onPanBegin();
            } else {
                this.mFinished = true;
            }
        }

        void cancelFling() {
            this.mScroller.forceFinished(true);
            this.finish();
        }

        private void finish() {
            if (!this.mFinished) {
                ZoomLayout.this.mPanDispatcher.onPanEnd();
            }
            this.mFinished = true;
        }

        public boolean isFinished() {
            return this.mScroller.isFinished();
        }

        @Override
        public void run() {
            if (!this.mScroller.isFinished() && this.mScroller.computeScrollOffset()) {
                int newY;
                int newX = this.mScroller.getCurrX();
                if (ZoomLayout.this.internalMoveBy(this.mCurrentX - newX, this.mCurrentY - (newY = this.mScroller.getCurrY()), true)) {
                    ZoomLayout.this.mPanDispatcher.onPan();
                }
                this.mCurrentX = newX;
                this.mCurrentY = newY;
                ViewCompat.postOnAnimation((View)ZoomLayout.this, (Runnable)this);
            } else {
                this.finish();
            }
        }
    }

    private class AnimatedZoomRunnable
    implements Runnable {
        boolean mCancelled = false;
        boolean mFinished = false;
        private long mStartTime = System.currentTimeMillis();
        private float mZoomStart;
        private float mZoomEnd;
        private float mFocalX;
        private float mFocalY;
        private float mStartX;
        private float mStartY;
        private float mTargetX;
        private float mTargetY;

        AnimatedZoomRunnable() {
        }

        boolean doScale() {
            return !NumberUtils.isEqual((float)this.mZoomStart, (float)this.mZoomEnd);
        }

        boolean doTranslate() {
            return !NumberUtils.isEqual((float)this.mStartX, (float)this.mTargetX) || !NumberUtils.isEqual((float)this.mStartY, (float)this.mTargetY);
        }

        boolean runValidation() {
            float scale = ZoomLayout.this.getScale();
            float newScale = NumberUtils.clamp((float)ZoomLayout.this.mMinScale, (float)scale, (float)ZoomLayout.this.mMaxScale);
            this.scale(scale, newScale, ZoomLayout.this.mFocusX, ZoomLayout.this.mFocusY, true);
            if (ZoomLayout.this.mAnimatedZoomRunnable.doScale() || ZoomLayout.this.mAnimatedZoomRunnable.doTranslate()) {
                ViewCompat.postOnAnimation((View)ZoomLayout.this, (Runnable)ZoomLayout.this.mAnimatedZoomRunnable);
                return true;
            }
            return false;
        }

        AnimatedZoomRunnable scale(float currentZoom, float targetZoom, float focalX, float focalY, boolean ensureTranslations) {
            this.mFocalX = focalX;
            this.mFocalY = focalY;
            this.mZoomStart = currentZoom;
            this.mZoomEnd = targetZoom;
            if (this.doScale()) {
                ZoomLayout.this.mZoomDispatcher.onZoomBegin(ZoomLayout.this.getScale());
            }
            if (ensureTranslations) {
                this.mStartX = ZoomLayout.this.getPosX();
                this.mStartY = ZoomLayout.this.getPosY();
                boolean scale = this.doScale();
                if (scale) {
                    ZoomLayout.this.mScaleMatrix.setScale(this.mZoomEnd, this.mZoomEnd, this.mFocalX, this.mFocalY);
                    ZoomLayout.this.matrixUpdated();
                }
                PointF p = ZoomLayout.this.getClosestValidTranslationPoint();
                this.mTargetX = p.x;
                this.mTargetY = p.y;
                if (scale) {
                    ZoomLayout.this.mScaleMatrix.setScale(this.mZoomStart, this.mZoomStart, ZoomLayout.this.mFocusX, ZoomLayout.this.mFocusY);
                    ZoomLayout.this.matrixUpdated();
                }
                if (this.doTranslate()) {
                    ZoomLayout.this.mPanDispatcher.onPanBegin();
                }
            }
            return this;
        }

        void cancel() {
            this.mCancelled = true;
            this.finish();
        }

        private void finish() {
            if (!this.mFinished) {
                if (this.doScale()) {
                    ZoomLayout.this.mZoomDispatcher.onZoomEnd(ZoomLayout.this.getScale());
                }
                if (this.doTranslate()) {
                    ZoomLayout.this.mPanDispatcher.onPanEnd();
                }
            }
            this.mFinished = true;
        }

        @Override
        public void run() {
            if (this.mCancelled || !this.doScale() && !this.doTranslate()) {
                return;
            }
            float t = this.interpolate();
            if (this.doScale()) {
                float newScale = this.mZoomStart + t * (this.mZoomEnd - this.mZoomStart);
                ZoomLayout.this.internalScale(newScale, this.mFocalX, this.mFocalY);
                ZoomLayout.this.mZoomDispatcher.onZoom(newScale);
            }
            if (this.doTranslate()) {
                float x = this.mStartX + t * (this.mTargetX - this.mStartX);
                float y = this.mStartY + t * (this.mTargetY - this.mStartY);
                ZoomLayout.this.internalMove(x, y, false);
                ZoomLayout.this.mPanDispatcher.onPan();
            }
            if (t < 1.0f) {
                ViewCompat.postOnAnimation((View)ZoomLayout.this, (Runnable)this);
            } else {
                this.finish();
            }
        }

        private float interpolate() {
            float t = 1.0f * (float)(System.currentTimeMillis() - this.mStartTime) / (float)ZoomLayout.this.mZoomDuration;
            t = Math.min(1.0f, t);
            return ZoomLayout.this.mAnimationInterpolator.getInterpolation(t);
        }
    }

    class GestureListener
    implements ScaleGestureDetector.OnScaleGestureListener,
    GestureDetector.OnGestureListener,
    GestureDetector.OnDoubleTapListener {
        private float mScaleOnActionDown;
        private boolean mScrolling = false;

        GestureListener() {
        }

        public boolean onSingleTapUp(MotionEvent e) {
            return false;
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            ZoomLayout.this.dispatchOnTab(e);
            return false;
        }

        public boolean onDoubleTap(MotionEvent e) {
            return false;
        }

        public boolean onDoubleTapEvent(MotionEvent e) {
            switch (e.getAction() & 0xFF) {
                case 1: {
                    ZoomLayout.this.dispatchOnDoubleTap(e);
                }
            }
            return false;
        }

        public void onLongPress(MotionEvent e) {
            if (!ZoomLayout.this.mScaleDetector.isInProgress()) {
                ZoomLayout.this.dispatchOnLongTap(e);
            }
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            boolean consumed = false;
            if (e2.getPointerCount() == 1 && !ZoomLayout.this.mScaleDetector.isInProgress()) {
                if (!this.mScrolling) {
                    ZoomLayout.this.mPanDispatcher.onPanBegin();
                    this.mScrolling = true;
                }
                if (consumed = ZoomLayout.this.internalMoveBy(distanceX, distanceY, true)) {
                    ZoomLayout.this.mPanDispatcher.onPan();
                }
                if (ZoomLayout.this.mAllowParentInterceptOnEdge && !consumed && (!ZoomLayout.this.isScaled() || ZoomLayout.this.mAllowParentInterceptOnScaled)) {
                    ZoomLayout.this.requestDisallowInterceptTouchEvent(false);
                }
            }
            return consumed;
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            float scale = ZoomLayout.this.getScale();
            float newScale = NumberUtils.clamp((float)ZoomLayout.this.mMinScale, (float)scale, (float)ZoomLayout.this.mMaxScale);
            if (NumberUtils.isEqual((float)newScale, (float)scale)) {
                ZoomLayout.this.mFlingRunnable = new FlingRunnable(ZoomLayout.this.getContext());
                ZoomLayout.this.mFlingRunnable.fling((int)velocityX, (int)velocityY);
                ViewCompat.postOnAnimation((View)ZoomLayout.this, (Runnable)ZoomLayout.this.mFlingRunnable);
                return true;
            }
            return false;
        }

        public void onShowPress(MotionEvent e) {
        }

        public boolean onDown(MotionEvent e) {
            this.mScaleOnActionDown = ZoomLayout.this.getScale();
            ZoomLayout.this.requestDisallowInterceptTouchEvent(true);
            ZoomLayout.this.cancelFling();
            ZoomLayout.this.cancelZoom();
            return false;
        }

        boolean onUp(MotionEvent e) {
            boolean consumed = false;
            if (this.mScrolling) {
                ZoomLayout.this.mPanDispatcher.onPanEnd();
                this.mScrolling = false;
                consumed = true;
            }
            if (ZoomLayout.this.mAnimatedZoomRunnable == null || ((ZoomLayout)ZoomLayout.this).mAnimatedZoomRunnable.mFinished) {
                ZoomLayout.this.mAnimatedZoomRunnable = new AnimatedZoomRunnable();
                consumed = ZoomLayout.this.mAnimatedZoomRunnable.runValidation() || consumed;
            }
            return consumed;
        }

        public boolean onScaleBegin(ScaleGestureDetector detector) {
            ZoomLayout.this.mZoomDispatcher.onZoomBegin(ZoomLayout.this.getScale());
            ZoomLayout.this.fixFocusPoint(detector.getFocusX(), detector.getFocusY());
            return true;
        }

        public boolean onScale(ScaleGestureDetector detector) {
            float scale = ZoomLayout.this.getScale() * detector.getScaleFactor();
            float scaleFactor = detector.getScaleFactor();
            if (Float.isNaN(scaleFactor) || Float.isInfinite(scaleFactor)) {
                return false;
            }
            ZoomLayout.this.internalScale(scale, ZoomLayout.this.mFocusX, ZoomLayout.this.mFocusY);
            ZoomLayout.this.mZoomDispatcher.onZoom(scale);
            return true;
        }

        public void onScaleEnd(ScaleGestureDetector detector) {
            ZoomLayout.this.mAnimatedZoomRunnable = new AnimatedZoomRunnable();
            ZoomLayout.this.mAnimatedZoomRunnable.runValidation();
            ZoomLayout.this.mZoomDispatcher.onZoomEnd(ZoomLayout.this.getScale());
        }
    }
}

