/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.zoomlayout;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.widget.OverScroller;
import android.widget.Scroller;

public abstract class ScrollerCompat {
    public static ScrollerCompat getScroller(Context context) {
        if (Build.VERSION.SDK_INT < 9) {
            return new PreGingerScroller(context);
        }
        return new GingerScroller(context);
    }

    public abstract boolean computeScrollOffset();

    public abstract void fling(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    public abstract void forceFinished(boolean var1);

    public abstract boolean isFinished();

    public abstract int getCurrX();

    public abstract int getCurrY();

    @TargetApi(value=9)
    private static class GingerScroller
    extends ScrollerCompat {
        OverScroller mScroller;

        public GingerScroller(Context context) {
            this.mScroller = new OverScroller(context);
        }

        @Override
        public boolean computeScrollOffset() {
            return this.mScroller.computeScrollOffset();
        }

        @Override
        public void fling(int startX, int startY, int velocityX, int velocityY, int minX, int maxX, int minY, int maxY, int overX, int overY) {
            this.mScroller.fling(startX, startY, velocityX, velocityY, minX, maxX, minY, maxY);
        }

        @Override
        public void forceFinished(boolean finished) {
            this.mScroller.forceFinished(finished);
        }

        @Override
        public boolean isFinished() {
            return this.mScroller.isFinished();
        }

        @Override
        public int getCurrX() {
            return this.mScroller.getCurrX();
        }

        @Override
        public int getCurrY() {
            return this.mScroller.getCurrY();
        }
    }

    private static class PreGingerScroller
    extends ScrollerCompat {
        Scroller mScroller;

        public PreGingerScroller(Context context) {
            this.mScroller = new Scroller(context);
        }

        @Override
        public boolean computeScrollOffset() {
            return this.mScroller.computeScrollOffset();
        }

        @Override
        public void fling(int startX, int startY, int velocityX, int velocityY, int minX, int maxX, int minY, int maxY, int overX, int overY) {
            this.mScroller.fling(startX, startY, velocityX, velocityY, minX, maxX, minY, maxY);
        }

        @Override
        public void forceFinished(boolean finished) {
            this.mScroller.forceFinished(finished);
        }

        @Override
        public boolean isFinished() {
            return this.mScroller.isFinished();
        }

        @Override
        public int getCurrX() {
            return this.mScroller.getCurrX();
        }

        @Override
        public int getCurrY() {
            return this.mScroller.getCurrY();
        }
    }
}

