/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.utils.enums;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Parcel;
import android.os.Parcelable;
import com.shopgun.android.utils.DisplayUtils;

public enum Orientation implements Parcelable
{
    PORTRAIT,
    LANDSCAPE;

    public static final Parcelable.Creator<Orientation> CREATOR;

    public static Orientation fromContext(Context ctx) {
        Orientation o = Orientation.internalFromConfiguration(ctx.getResources().getConfiguration());
        if (o == null) {
            int width;
            int height = DisplayUtils.getScreenHeight(ctx);
            o = height > (width = DisplayUtils.getScreenWidth(ctx)) ? PORTRAIT : LANDSCAPE;
        }
        return o;
    }

    public static Orientation fromConfiguration(Configuration config) {
        Orientation o = Orientation.internalFromConfiguration(config);
        return o == null ? PORTRAIT : o;
    }

    private static Orientation internalFromConfiguration(Configuration config) {
        if (config != null) {
            switch (config.orientation) {
                case 2: {
                    return LANDSCAPE;
                }
                case 1: {
                    return PORTRAIT;
                }
            }
        }
        return null;
    }

    public boolean isLandscape() {
        return this == LANDSCAPE;
    }

    public boolean isPortrait() {
        return this == PORTRAIT;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.name());
    }

    static {
        CREATOR = new Parcelable.Creator<Orientation>(){

            public Orientation createFromParcel(Parcel source) {
                return Orientation.valueOf(source.readString());
            }

            public Orientation[] newArray(int size) {
                return new Orientation[size];
            }
        };
    }
}

