/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.utils;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.List;

public class ParcelableUtils {
    public static final String TAG = ParcelableUtils.class.getSimpleName();

    private ParcelableUtils() {
    }

    public static <T extends Parcelable> T copyParcelable(T obj, Parcelable.Creator<T> creator) {
        Parcel parcel = Parcel.obtain();
        obj.writeToParcel(parcel, 0);
        parcel.setDataPosition(0);
        return (T)((Parcelable)creator.createFromParcel(parcel));
    }

    public static <T extends Parcelable> List<T> copyParcelable(List<T> list, Parcelable.Creator<T> creator) {
        ArrayList<Parcelable> tmp = new ArrayList<Parcelable>();
        for (Parcelable t : list) {
            tmp.add(ParcelableUtils.copyParcelable(t, creator));
        }
        return tmp;
    }
}

