/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.utils;

import android.graphics.Color;
import androidx.annotation.ColorInt;
import androidx.annotation.IntRange;
import com.shopgun.android.utils.Tag;
import java.util.Locale;

public class ColorUtils {
    public static final String TAG = Tag.from(ColorUtils.class);
    private static final String ARGB_FORMAT = "#%08X";
    private static final String RGB_FORMAT = "#%06X";
    private static final String HSV_FORMAT = "hsv[%.2f, %.2f, %.2f]";

    @ColorInt
    public static int getCompliment(@ColorInt int color) {
        int alpha = Color.alpha((int)color);
        int red = Color.red((int)color);
        int blue = Color.blue((int)color);
        int green = Color.green((int)color);
        red = ~red & 0xFF;
        blue = ~blue & 0xFF;
        green = ~green & 0xFF;
        return Color.argb((int)alpha, (int)red, (int)green, (int)blue);
    }

    public static String toARGBString(@ColorInt int color) {
        return String.format(Locale.US, ARGB_FORMAT, color);
    }

    public static String toRGBString(@ColorInt int color) {
        return String.format(Locale.US, RGB_FORMAT, 0xFFFFFF & color);
    }

    public static String toHsvString(int color) {
        return ColorUtils.toHsvString(ColorUtils.toHSV(color));
    }

    public static String toHsvString(float[] hsv) {
        return String.format(Locale.US, HSV_FORMAT, Float.valueOf(hsv[0]), Float.valueOf(hsv[1]), Float.valueOf(hsv[2]));
    }

    public static float[] toHSV(@ColorInt int color) {
        float[] hsv = new float[3];
        Color.colorToHSV((int)color, (float[])hsv);
        return hsv;
    }

    @ColorInt
    public static int setAlphaComponent(@ColorInt int color, @IntRange(from=0L, to=255L) int alpha) {
        return androidx.core.graphics.ColorUtils.setAlphaComponent((int)color, (int)alpha);
    }

    public static double calculateLuminance(@ColorInt int color) {
        return androidx.core.graphics.ColorUtils.calculateLuminance((int)color);
    }

    public static double calculateContrast(@ColorInt int foreground, @ColorInt int background) {
        return androidx.core.graphics.ColorUtils.calculateContrast((int)foreground, (int)background);
    }

    public static int calculateMinimumAlpha(@ColorInt int foreground, @ColorInt int background, float minContrastRatio) {
        return androidx.core.graphics.ColorUtils.calculateMinimumAlpha((int)foreground, (int)background, (float)minContrastRatio);
    }
}

