/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.utils.recyclerview;

import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;

public class RecyclerViewObserver
extends RecyclerView.OnScrollListener {
    public static final String TAG = RecyclerViewObserver.class.getSimpleName();
    final OnRecyclerViewScroller mSlider;
    Direction mDirection = Direction.NONE;

    public RecyclerViewObserver(OnRecyclerViewScroller slider) {
        this.mSlider = slider;
    }

    public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
        super.onScrollStateChanged(recyclerView, newState);
        switch (newState) {
            case 1: {
                this.mDirection = Direction.NONE;
                break;
            }
            case 2: {
                if (this.mDirection == Direction.NONE && this.isEverythingVisible(recyclerView)) {
                    this.mSlider.onScrollDown();
                    break;
                }
                if (this.mDirection == Direction.UP) {
                    this.mSlider.onScrollUp();
                    break;
                }
                if (this.mDirection != Direction.DOWN) break;
                this.mSlider.onScrollDown();
            }
        }
    }

    public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
        super.onScrolled(recyclerView, dx, dy);
        this.mDirection = dy > 0 ? Direction.UP : (dy == 0 ? Direction.NONE : Direction.DOWN);
    }

    private boolean isEverythingVisible(RecyclerView recyclerView) {
        LinearLayoutManager llm = (LinearLayoutManager)recyclerView.getLayoutManager();
        int scrollY = recyclerView.getScrollY();
        int first = llm.findFirstCompletelyVisibleItemPosition();
        int lastPos = llm.findLastCompletelyVisibleItemPosition();
        int itemCount = recyclerView.getAdapter().getItemCount();
        return scrollY == 0 && first == 0 && lastPos == itemCount - 1;
    }

    public static interface OnRecyclerViewScroller {
        public void onScrollDown();

        public void onScrollUp();
    }

    public static enum Direction {
        NONE,
        UP,
        DOWN;

    }
}

