/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.utils.log;

import com.shopgun.android.utils.log.L;
import com.shopgun.android.utils.log.Logger;

public class LogUtil {
    public static final String TAG = LogUtil.class.getSimpleName();
    private static final int CALLING_ELEMENT = 4;

    public static void printMethod() {
        LogUtil.printMethod(L.getLogger(), 4);
    }

    public static void printMethod(Logger logger) {
        LogUtil.printMethod(logger, 4);
    }

    public static void printMethod(Logger logger, int element) {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        String tag = LogUtil.getTagFromTrace(trace, element);
        String msg = LogUtil.getMethodFromTrace(trace, element);
        logger.d(tag, msg);
    }

    public static void printStackTrace() {
        LogUtil.printStackTrace(L.getLogger());
    }

    public static void printStackTrace(Logger logger) {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        LogUtil.printStackTrace(logger, LogUtil.getTagFromTrace(trace), trace, 4, trace.length - 1);
    }

    public static void printStackTrace(String tag) {
        LogUtil.printStackTrace(L.getLogger(), tag);
    }

    public static void printStackTrace(Logger logger, String tag) {
        LogUtil.printStackTrace(logger, tag, Thread.currentThread().getStackTrace());
    }

    private static void printStackTrace(Logger logger, String tag, StackTraceElement[] trace) {
        for (StackTraceElement ste : trace) {
            logger.d(tag, String.valueOf(ste));
        }
    }

    public static void printStackTrace(String tag, int first, int last) {
        LogUtil.printStackTrace(L.getLogger(), tag, first, last);
    }

    public static void printStackTrace(Logger logger, String tag, int first, int last) {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        LogUtil.printStackTrace(logger, tag, trace, first, last);
    }

    private static void printStackTrace(Logger logger, String tag, StackTraceElement[] trace, int first, int last) {
        first = Math.min(first, trace.length);
        last = Math.min(last, trace.length);
        for (int i = first; i < last; ++i) {
            StackTraceElement ste = trace[i];
            logger.d(tag, String.valueOf(ste));
        }
    }

    public static String getMethodFromTrace(StackTraceElement[] trace) {
        return LogUtil.getMethodFromTrace(trace, 4);
    }

    public static String getMethodFromTrace(StackTraceElement[] trace, int element) {
        StackTraceElement ste = trace[element];
        return LogUtil.getMethodFromElement(ste);
    }

    public static String getMethodFromElement(StackTraceElement element) {
        return element.getMethodName() + "(" + element.getFileName() + ":" + element.getLineNumber() + ")";
    }

    private static String getTagFromTrace(StackTraceElement[] trace) {
        return LogUtil.getTagFromTrace(trace, 4);
    }

    public static String getTagFromTrace(StackTraceElement[] trace, int element) {
        return LogUtil.getTagFromElement(trace[element]);
    }

    private static String getTagFromElement(StackTraceElement element) {
        String[] split = element.getClassName().split("\\.");
        return split[split.length - 1];
    }
}

