/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.utils;

import android.view.MotionEvent;
import android.view.View;

public class ToStringUtils {
    public static String pageScrollState(int state) {
        switch (state) {
            case 1: {
                return "SCROLL_STATE_DRAGGING";
            }
            case 0: {
                return "SCROLL_STATE_IDLE";
            }
            case 2: {
                return "SCROLL_STATE_SETTLING";
            }
        }
        return "SCROLL_STATE_UNKNOWN";
    }

    public static String orientation(int orientation) {
        switch (orientation) {
            case 0: {
                return "ORIENTATION_UNDEFINED";
            }
            case 1: {
                return "ORIENTATION_PORTRAIT";
            }
            case 2: {
                return "ORIENTATION_LANDSCAPE";
            }
            case 3: {
                return "ORIENTATION_SQUARE";
            }
        }
        return "ORIENTATION_UNKNOWN";
    }

    public static String measureSpecMode(int mode) {
        switch (mode) {
            case 0: {
                return "UNSPECIFIED";
            }
            case 0x40000000: {
                return "EXACTLY";
            }
            case -2147483648: {
                return "AT_MOST";
            }
        }
        return "UNSPECIFIED";
    }

    public static String visibility(View view) {
        return ToStringUtils.visibility(view.getVisibility());
    }

    public static String visibility(int visibility) {
        switch (visibility) {
            case 0: {
                return "VISIBLE";
            }
            case 4: {
                return "INVISIBLE";
            }
            case 8: {
                return "GONE";
            }
        }
        return "UNKNOWN";
    }

    public static String measureSpec(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        return String.format("MeasureSpec[ w: %s %s, h: %s %s ]", ToStringUtils.measureSpecMode(widthMode).toLowerCase(), widthSize, ToStringUtils.measureSpecMode(heightMode).toLowerCase(), heightSize);
    }

    public static String motionEventAction(MotionEvent ev) {
        return ToStringUtils.motionEventAction(ev.getAction() & 0xFF);
    }

    public static String motionEventAction(int action) {
        switch (action) {
            case 0: {
                return "ACTION_DOWN";
            }
            case 1: {
                return "ACTION_UP";
            }
            case 2: {
                return "ACTION_MOVE";
            }
            case 3: {
                return "ACTION_CANCEL";
            }
            case 4: {
                return "ACTION_OUTSIDE";
            }
            case 5: {
                return "ACTION_POINTER_DOWN";
            }
            case 6: {
                return "ACTION_POINTER_UP";
            }
            case 7: {
                return "ACTION_HOVER_MOVE";
            }
            case 8: {
                return "ACTION_SCROLL";
            }
            case 9: {
                return "ACTION_HOVER_ENTER";
            }
            case 10: {
                return "ACTION_HOVER_EXIT";
            }
            case 11: {
                return "ACTION_BUTTON_PRESS";
            }
            case 12: {
                return "ACTION_BUTTON_RELEASE";
            }
            case 65280: {
                return "ACTION_POINTER_INDEX_MASK";
            }
            case 261: {
                return "ACTION_POINTER_2_DOWN";
            }
            case 517: {
                return "ACTION_POINTER_3_DOWN";
            }
            case 262: {
                return "ACTION_POINTER_2_UP";
            }
            case 518: {
                return "ACTION_POINTER_3_UP";
            }
        }
        return "ACTION_UNKNOWN";
    }

    public static String onTrimMemoryToString(int level) {
        switch (level) {
            case 40: {
                return "TRIM_MEMORY_BACKGROUND";
            }
            case 80: {
                return "TRIM_MEMORY_COMPLETE";
            }
            case 60: {
                return "TRIM_MEMORY_MODERATE";
            }
            case 15: {
                return "TRIM_MEMORY_RUNNING_CRITICAL";
            }
            case 10: {
                return "TRIM_MEMORY_RUNNING_LOW";
            }
            case 5: {
                return "TRIM_MEMORY_RUNNING_MODERATE";
            }
            case 20: {
                return "TRIM_MEMORY_UI_HIDDEN";
            }
        }
        return "UNKNOWN";
    }

    public static String logLevelToString(int logLevel) {
        switch (logLevel) {
            case 2: {
                return "VERBOSE";
            }
            case 3: {
                return "DEBUG";
            }
            case 4: {
                return "INFO";
            }
            case 5: {
                return "WARN";
            }
            case 6: {
                return "ERROR";
            }
            case 7: {
                return "ASSERT";
            }
        }
        return "UNKNOWN";
    }
}

