/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.utils;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Dialog;
import android.app.Fragment;
import android.content.Context;
import android.os.IBinder;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import com.shopgun.android.utils.Tag;

public class KeyboardUtils {
    public static final String TAG = Tag.from(KeyboardUtils.class);

    private KeyboardUtils() {
    }

    public static void show(Dialog dialog) {
        if (dialog != null) {
            KeyboardUtils.show(dialog.getCurrentFocus());
        }
    }

    public static void show(android.support.v4.app.Fragment fragment) {
        if (fragment != null) {
            KeyboardUtils.show((Activity)fragment.getActivity());
        }
    }

    @TargetApi(value=11)
    public static void show(Fragment fragment) {
        if (fragment != null) {
            KeyboardUtils.show(fragment.getActivity());
        }
    }

    public static void show(Activity activity) {
        if (activity != null) {
            KeyboardUtils.show(activity.getCurrentFocus());
        }
    }

    public static void show(View view) {
        KeyboardUtils.setKeyboardVisible(view, false);
    }

    public static void hide(Dialog dialog) {
        if (dialog != null) {
            KeyboardUtils.hide(dialog.getCurrentFocus());
        }
    }

    public static void hide(android.support.v4.app.Fragment fragment) {
        if (fragment != null) {
            KeyboardUtils.hide((Activity)fragment.getActivity());
        }
    }

    @TargetApi(value=11)
    public static void hide(Fragment fragment) {
        if (fragment != null) {
            KeyboardUtils.hide(fragment.getActivity());
        }
    }

    public static void hide(Activity activity) {
        if (activity != null) {
            KeyboardUtils.hide(activity.getCurrentFocus());
        }
    }

    public static void hide(View view) {
        KeyboardUtils.setKeyboardVisible(view, true);
    }

    public static void setKeyboardVisible(View view, boolean visible) {
        if (view != null) {
            KeyboardUtils.setKeyboardVisible(view.getContext(), view, visible);
        }
    }

    public static void setKeyboardVisible(Context context, View view, boolean visible) {
        if (view != null) {
            KeyboardUtils.setKeyboardVisible(context, view.getWindowToken(), visible);
        }
    }

    public static void setKeyboardVisible(Context context, IBinder windowToken, boolean visible) {
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        if (visible) {
            imm.toggleSoftInput(2, 1);
        } else if (windowToken != null) {
            imm.hideSoftInputFromWindow(windowToken, 0);
        }
    }
}

