/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.utils;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import com.shopgun.android.utils.Tag;

public class BitmapUtils {
    public static final String TAG = Tag.from(BitmapUtils.class);

    public static Bitmap getBitmapFromView(View view, int defBackgroundColor) {
        Bitmap returnedBitmap = Bitmap.createBitmap((int)view.getWidth(), (int)view.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(returnedBitmap);
        Drawable bgDrawable = view.getBackground();
        if (bgDrawable != null) {
            bgDrawable.draw(canvas);
        } else {
            canvas.drawColor(defBackgroundColor);
        }
        view.draw(canvas);
        return returnedBitmap;
    }

    public static int sizeOf(Bitmap bitmap) {
        if (Build.VERSION.SDK_INT >= 19) {
            return bitmap.getAllocationByteCount();
        }
        return bitmap.getByteCount();
    }

    public static int sizeOfKb(Bitmap bitmap) {
        return BitmapUtils.sizeOf(bitmap) / 1024;
    }
}

