/*******************************************************************************
 * Copyright 2015 ShopGun
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/

package com.shopgun.android.sdk.model.interfaces;

public interface IErn<T> {

    public static final String TYPE_CATALOG = "catalog";
    public static final String TYPE_DEALER = "dealer";
    public static final String TYPE_OFFER = "offer";
    public static final String TYPE_SHOPPINGLIST = "shopping:list";
    public static final String TYPE_STORE = "store";
    public static final String TYPE_USER = "user";
    public static final String TYPE_COUNTRY = "country";

    /**
     * Get the id for this object.
     *
     * @return A {@link String}, or {@code null}
     */
    public String getId();

    /**
     * Set the id for this object.
     *
     * @param id An id
     * @return this object
     */
    public T setId(String id);

    /**
     * Get the ShopGun Resource Name (ERN) for this object.
     * <p>ERN is a <i>unique</i> identifier for objects in the ShopGun API v2, and should in most cases be
     * generated by the server, and <i>not</i> by the client</p>
     *
     * @return A {@link String}, or null
     */
    public String getErn();

    /**
     * Set the ShopGun Resource Name (ERN) for this object.
     * <p>ERN is a <i>unique</i> identifier for objects in the ShopGun API v2, and should in most cases be
     * generated by the server, and <i>not</i> by the client</p>
     *
     * @param ern A String
     * @return this object
     */
    public T setErn(String ern);

    /**
     * Returns a ERN type. If a type doesn't exist, the id will be returned
     *
     * @return A string, or null
     */
    public String getErnType();

}
