/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.utils;

public class Version {
    public static final String TAG = Version.class.getSimpleName();
    public static final int MASK_MAJOR = 1000000;
    public static final int MASK_MINOR = 10000;
    public static final int MASK_PATCH = 100;
    private final int mVersion;
    private final String mBuild;

    public Version(int version) {
        this(version, null);
    }

    public Version(int version, String build) {
        this.mVersion = version;
        this.mBuild = build;
    }

    public Version(int major, int minor, int patch, String build) {
        this(Version.buildVersion(major, minor, patch), build);
    }

    public Version(int major, int minor, int patch) {
        this(major, minor, patch, null);
    }

    public Version(int major, int minor, int patch, int build) {
        this(major, minor, patch, String.valueOf(build));
    }

    private static int buildVersion(int major, int minor, int patch) {
        return major * 1000000 + minor * 10000 + patch * 100;
    }

    public int getCode() {
        return this.mVersion;
    }

    public int getMajor() {
        return this.mVersion / 1000000;
    }

    public int getMinor() {
        return this.mVersion % 1000000 / 10000;
    }

    public int getPatch() {
        return this.mVersion % 10000 / 100;
    }

    public String getBuild() {
        return this.mBuild;
    }

    public String getName() {
        if (this.mBuild != null) {
            return String.format("%s.%s.%s-%s", this.getMajor(), this.getMinor(), this.getPatch(), this.mBuild);
        }
        return String.format("%s.%s.%s", this.getMajor(), this.getMinor(), this.getPatch());
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return this.mVersion == version.mVersion;
    }

    public int hashCode() {
        return this.mVersion;
    }
}

