/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.utils;

import com.shopgun.android.sdk.utils.Constants;
import java.util.Locale;
import java.util.regex.Pattern;

public class Validator {
    public static final String TAG = Constants.getTag(Validator.class);
    public static final String APP_VERSION_FORMAT = "(\\d+)\\.(\\d+)\\.(\\d+)([+-][0-9A-Za-z-.]*)?";
    public static final String xAPP_VERSION_FORMAT = "(\\d+)\\.(\\d+)\\.(\\d+)([-]([0-9A-Za-z-.]+)*)?";

    public static boolean isBirthyearValid(Integer birthyear) {
        return birthyear >= 1900 && birthyear <= 2015;
    }

    public static boolean isEmailValid(String email) {
        if (email == null) {
            return false;
        }
        String[] split = email.split("@");
        if (split.length != 2) {
            return false;
        }
        if (split[0].length() == 0 || split[1].length() == 0) {
            return false;
        }
        return email.trim().equals(email);
    }

    public static boolean isGenderValid(String gender) {
        if (gender != null) {
            String g = gender.toLowerCase(Locale.ENGLISH).trim();
            return g.equals("male") || g.equals("female");
        }
        return false;
    }

    public static boolean isAppVersionValid(String version) {
        return version != null && Pattern.compile(APP_VERSION_FORMAT).matcher(version).matches();
    }
}

