/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.utils;

import com.shopgun.android.sdk.network.Request;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.IllegalCharsetNameException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;

public class SgnUtils {
    public static final String TAG = SgnUtils.class.getSimpleName();
    public static final String UUID_REGEX = "([a-fA-F0-9]{8}-(?:[a-fA-F0-9]{4}-){3}[a-fA-F0-9]{12}){1}";
    private static final Pattern UUID_PATTERN = Pattern.compile("([a-fA-F0-9]{8}-(?:[a-fA-F0-9]{4}-){3}[a-fA-F0-9]{12}){1}");
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZZZZ";
    private static final String DATE_EPOC = "1970-01-01T00:00:00+0000";
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZZZZ", Locale.US);
    private static final Object DATE_LOCK = new Object();

    private SgnUtils() {
    }

    public static String createUUID() {
        return UUID.randomUUID().toString();
    }

    public static void isValidUuidOrThrow(String uuid) {
        if (!SgnUtils.isValidUUID(uuid)) {
            throw new IllegalArgumentException("The given UUID isn't valid: " + uuid);
        }
    }

    public static boolean isValidUUID(String uuid) {
        return UUID_PATTERN.matcher(uuid).matches();
    }

    public static String requestToUrlAndQueryString(Request<?> r) {
        if (r == null || r.getUrl() == null) {
            return null;
        }
        if (r.getParameters() == null || r.getParameters().isEmpty()) {
            return r.getUrl();
        }
        return r.getUrl() + "?" + SgnUtils.mapToQueryString(r.getParameters(), r.getParamsEncoding());
    }

    public static String mapToQueryString(Map<String, String> apiParams, String encoding) {
        StringBuilder sb = new StringBuilder();
        if (apiParams != null) {
            LinkedList<String> keys = new LinkedList<String>(apiParams.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                String value = SgnUtils.valueIsNull(apiParams.get(key));
                if (sb.length() > 0) {
                    sb.append("&");
                }
                sb.append(SgnUtils.encode(key, encoding)).append("=").append(SgnUtils.encode(value, encoding));
            }
        }
        return sb.toString();
    }

    private static String valueIsNull(Object value) {
        return value == null ? "" : value.toString();
    }

    public static String encode(String value, String encoding) {
        try {
            value = URLEncoder.encode(value, encoding);
        }
        catch (NullPointerException e) {
            value = URLEncoder.encode(value);
        }
        catch (UnsupportedEncodingException e) {
            value = URLEncoder.encode(value);
        }
        catch (IllegalCharsetNameException e) {
            value = URLEncoder.encode(value);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date stringToDate(String date) {
        Object object = DATE_LOCK;
        synchronized (object) {
            try {
                return SIMPLE_DATE_FORMAT.parse(date);
            }
            catch (ParseException e) {
                return new Date(0L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date stringToDateThrows(String date) throws ParseException {
        Object object = DATE_LOCK;
        synchronized (object) {
            return SIMPLE_DATE_FORMAT.parse(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dateToString(Date date) {
        Object object = DATE_LOCK;
        synchronized (object) {
            try {
                return SIMPLE_DATE_FORMAT.format(date);
            }
            catch (NullPointerException e) {
                return DATE_EPOC;
            }
        }
    }

    public static boolean isSuccess(int statusCode) {
        return 200 <= statusCode && statusCode < 300 || statusCode == 304;
    }

    public static <T> List<T> copyIterator(Iterator<T> it) {
        ArrayList<T> copy = new ArrayList<T>();
        while (it.hasNext()) {
            copy.add(it.next());
        }
        return copy;
    }

    public static byte[] intToByteArray(int integer) {
        byte[] result = new byte[]{(byte)((integer & 0xFF000000) >> 24), (byte)((integer & 0xFF0000) >> 16), (byte)((integer & 0xFF00) >> 8), (byte)(integer & 0xFF)};
        return result;
    }
}

