/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.utils;

import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.utils.Constants;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class SgnThreadFactory
implements ThreadFactory {
    public static final String TAG = Constants.getTag(SgnThreadFactory.class);
    private static final String DEFAULT_THREAD_NAME = "sgn-sdk-";
    private static final int DEFAULT_THREAD_PRIORITY = 4;
    private static final AtomicInteger poolNumber = new AtomicInteger(1);
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;
    private final int threadPriority;

    public SgnThreadFactory() {
        this(DEFAULT_THREAD_NAME);
    }

    public SgnThreadFactory(String threadNamePrefix) {
        this(4, threadNamePrefix);
    }

    public SgnThreadFactory(int threadPriority, String threadNamePrefix) {
        this.threadPriority = threadPriority;
        SecurityManager s = System.getSecurityManager();
        this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = threadNamePrefix + poolNumber.getAndIncrement() + "-thread-";
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
        if (t.isDaemon()) {
            t.setDaemon(false);
        }
        t.setPriority(this.threadPriority);
        return t;
    }

    private static class LogUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        Thread.UncaughtExceptionHandler mUncaughtExceptionHandler;

        public LogUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            this.mUncaughtExceptionHandler = uncaughtExceptionHandler;
        }

        @Override
        public void uncaughtException(Thread thread, Throwable ex) {
            SgnLog.e(TAG, thread.getName() + " crashed", ex);
            if (this.mUncaughtExceptionHandler != null) {
                this.mUncaughtExceptionHandler.uncaughtException(thread, ex);
            }
        }
    }
}

