/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.utils;

import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.model.Shoppinglist;
import com.shopgun.android.sdk.model.ShoppinglistItem;
import com.shopgun.android.sdk.utils.Constants;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ListUtils {
    public static final String TAG = Constants.getTag(ListUtils.class);
    public static final String FIRST_ITEM = "00000000-0000-0000-0000-000000000000";

    public static void printItem(String tag, ShoppinglistItem s) {
        SgnLog.d(tag, "Item " + s.getDescription() + " prevId( " + s.getPreviousId() + ") - modified( " + s.getModified().toGMTString() + " ) ");
    }

    public static List<ShoppinglistItem> setPrevious(List<ShoppinglistItem> list, int prevPos, int movePos) {
        ArrayList<ShoppinglistItem> tmp = new ArrayList<ShoppinglistItem>();
        if (list == null || list.isEmpty() || movePos < 0) {
            return tmp;
        }
        ShoppinglistItem move = list.get(movePos);
        boolean isFirst = prevPos < 0;
        ShoppinglistItem prev = isFirst ? null : list.get(prevPos);
        String prevId = isFirst ? FIRST_ITEM : prev.getId();
        for (ShoppinglistItem sli : list) {
            if (sli.getPreviousId().equals(prevId)) {
                sli.setPreviousId(move.getId());
                tmp.add(sli);
                continue;
            }
            if (!sli.getPreviousId().equals(move.getId())) continue;
            sli.setPreviousId(move.getPreviousId());
            tmp.add(sli);
        }
        move.setPreviousId(prevId);
        tmp.add(move);
        return tmp;
    }

    public static void sortItems(List<ShoppinglistItem> items) {
        int size = items.size();
        HashSet<String> allId = new HashSet<String>(size);
        for (ShoppinglistItem sli : items) {
            allId.add(sli.getId());
        }
        ArrayList<ShoppinglistItem> nil = new ArrayList<ShoppinglistItem>(size);
        ArrayList<ShoppinglistItem> first = new ArrayList<ShoppinglistItem>(size);
        ArrayList<ShoppinglistItem> orphan = new ArrayList<ShoppinglistItem>(size);
        HashMap<String, ShoppinglistItem> prevItems = new HashMap<String, ShoppinglistItem>(size);
        for (ShoppinglistItem sli : items) {
            String prevId = sli.getPreviousId();
            if (prevId == null) {
                nil.add(sli);
                continue;
            }
            if (FIRST_ITEM.equals(prevId)) {
                first.add(sli);
                continue;
            }
            if (!prevItems.containsKey(prevId) && allId.contains(prevId)) {
                prevItems.put(prevId, sli);
                continue;
            }
            orphan.add(sli);
        }
        items.clear();
        Collections.sort(first, ShoppinglistItem.TITLE_ASCENDING);
        Collections.sort(nil, ShoppinglistItem.TITLE_ASCENDING);
        Collections.sort(orphan, ShoppinglistItem.TITLE_ASCENDING);
        ArrayList<ShoppinglistItem> newItems = new ArrayList<ShoppinglistItem>(size);
        newItems.addAll(nil);
        newItems.addAll(first);
        newItems.addAll(orphan);
        Iterator<Object> iterator = newItems.iterator();
        while (iterator.hasNext()) {
            ShoppinglistItem sli;
            ShoppinglistItem next = sli = (ShoppinglistItem)iterator.next();
            while (next != null) {
                String id2 = next.getId();
                items.add(next);
                next = (ShoppinglistItem)prevItems.get(id2);
                prevItems.remove(id2);
            }
        }
        for (ShoppinglistItem s : prevItems.values()) {
            items.add(s);
        }
    }

    public static long getLargestTimeStamp(List<ShoppinglistItem> list) {
        long t = 0L;
        for (ShoppinglistItem sli : list) {
            t = Math.max(sli.getModified().getTime(), t);
        }
        return t;
    }

    public static HashSet<String> getShoppinglistIdsFromItems(List<ShoppinglistItem> items) {
        HashSet<String> ids = new HashSet<String>(items.size());
        for (ShoppinglistItem sli : items) {
            ids.add(sli.getShoppinglistId());
        }
        return ids;
    }

    public static HashSet<String> getShoppinglistIdsFromLists(List<Shoppinglist> lists) {
        HashSet<String> ids = new HashSet<String>(lists.size());
        for (Shoppinglist sl : lists) {
            ids.add(sl.getId());
        }
        return ids;
    }
}

