/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.utils;

import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import com.shopgun.android.sdk.corekit.LifecycleManager;
import com.shopgun.android.sdk.log.SgnLog;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LifecycleEventLogger
extends LifecycleManager.SimpleCallback {
    public static final String TAG = LifecycleEventLogger.class.getSimpleName();
    Map<Activity, FragmentManagerProxy> mMap = new HashMap<Activity, FragmentManagerProxy>();

    @Override
    public void onStart(Activity activity) {
        FragmentManagerProxy proxy = new FragmentManagerProxy(activity);
        proxy.addOnBackStackChangedListener(new OnBackStackChangedListener(){

            @Override
            public void onBackStackChanged(List<FragmentProxy> fragments) {
                StringBuilder sb = new StringBuilder();
                for (FragmentProxy fragment : fragments) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(fragment.getSimpleName());
                }
                SgnLog.d(TAG, "Fragments: " + sb.toString());
            }
        });
        this.mMap.put(activity, proxy);
    }

    @Override
    public void onStop(Activity activity) {
        this.mMap.get(activity).removeOnBackStackChangedListener();
    }

    @Override
    public void onDestroy(Activity activity) {
    }

    static interface OnBackStackChangedListener {
        public void onBackStackChanged(List<FragmentProxy> var1);
    }

    private static class FragmentManagerProxy {
        Activity mActivity;
        OnBackStackChangedListener mListener;
        FragmentActivity mFragmentActivity;
        List<Fragment> mFragments;
        List<android.support.v4.app.Fragment> mSupportFragments;
        FragmentManager.OnBackStackChangedListener mOnBackStackChangedListener = new FragmentManager.OnBackStackChangedListener(){

            public void onBackStackChanged() {
                FragmentManager manager = FragmentManagerProxy.this.mActivity.getFragmentManager();
                try {
                    Field active = manager.getClass().getDeclaredField("mActive");
                    active.setAccessible(true);
                    FragmentManagerProxy.this.mFragments = (List)active.get(manager);
                }
                catch (NoSuchFieldException e) {
                    SgnLog.d(TAG, "mActive field doesn't exist in FragmentManager");
                }
                catch (IllegalAccessException e) {
                    SgnLog.d(TAG, "Couldn't read the value of mActive field.");
                }
                ArrayList<FragmentProxy> proxy = new ArrayList<FragmentProxy>();
                for (Fragment fragment : FragmentManagerProxy.this.mFragments) {
                    if (fragment == null) continue;
                    proxy.add(new FragmentProxy(fragment));
                }
                if (FragmentManagerProxy.this.mListener != null) {
                    FragmentManagerProxy.this.mListener.onBackStackChanged(proxy);
                }
            }
        };
        FragmentManager.OnBackStackChangedListener mSupportOnBackStackChangedListener = new FragmentManager.OnBackStackChangedListener(){

            public void onBackStackChanged() {
                FragmentManagerProxy.this.mSupportFragments = FragmentManagerProxy.this.mFragmentActivity.getSupportFragmentManager().getFragments();
                ArrayList<FragmentProxy> fragmentProxies = new ArrayList<FragmentProxy>();
                for (android.support.v4.app.Fragment fragment : FragmentManagerProxy.this.mSupportFragments) {
                    if (fragment == null) continue;
                    fragmentProxies.add(new FragmentProxy(fragment));
                }
                if (FragmentManagerProxy.this.mListener != null) {
                    FragmentManagerProxy.this.mListener.onBackStackChanged(fragmentProxies);
                }
            }
        };

        public FragmentManagerProxy(Activity activity) {
            this.mActivity = activity;
            if (this.mActivity instanceof FragmentActivity) {
                this.mFragmentActivity = (FragmentActivity)this.mActivity;
            }
        }

        public void addOnBackStackChangedListener(OnBackStackChangedListener listener) {
            this.mListener = listener;
            this.mActivity.getFragmentManager().addOnBackStackChangedListener(this.mOnBackStackChangedListener);
            if (this.mFragmentActivity != null) {
                this.mFragmentActivity.getSupportFragmentManager().addOnBackStackChangedListener(this.mSupportOnBackStackChangedListener);
            }
        }

        public void removeOnBackStackChangedListener() {
            this.mListener = null;
            this.mActivity.getFragmentManager().removeOnBackStackChangedListener(this.mOnBackStackChangedListener);
            if (this.mFragmentActivity != null) {
                this.mFragmentActivity.getSupportFragmentManager().removeOnBackStackChangedListener(this.mSupportOnBackStackChangedListener);
            }
        }
    }

    private static class FragmentProxy {
        Fragment mFrameworkFragment;
        android.support.v4.app.Fragment mSupportFragment;

        public FragmentProxy(Fragment fragment) {
            this.mFrameworkFragment = fragment;
        }

        public FragmentProxy(android.support.v4.app.Fragment fragment) {
            this.mSupportFragment = fragment;
        }

        public String getSimpleName() {
            return FragmentProxy.getSimpleName(this.isSupport() ? this.mSupportFragment : this.mFrameworkFragment);
        }

        public boolean isSupport() {
            return this.mFrameworkFragment == null;
        }

        public String getType() {
            return FragmentProxy.getCanonicalName(this.isSupport() ? this.mSupportFragment : this.mFrameworkFragment);
        }

        private static String getCanonicalName(Object o) {
            return o.getClass().getCanonicalName();
        }

        private static String getSimpleName(Object o) {
            return o.getClass().getSimpleName();
        }
    }
}

