/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.utils;

import android.support.annotation.NonNull;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class FIFOMaxSizeCollections {
    public static <T> Collection getFIFOMaxSizeCollection(Collection<T> collection, int maxSize) {
        return new FIFOMaxSizeCollection<T>(collection, maxSize);
    }

    public static <T> Collection getFIFOMaxSizeList(List<T> list, int maxSize) {
        return new FIFOMaxSizeList<T>(list, maxSize);
    }

    static class FIFOMaxSizeList<E>
    extends FIFOMaxSizeCollection<E>
    implements List<E> {
        List<E> mList;

        public FIFOMaxSizeList(List<E> list, int maxSize) {
            super(list, maxSize);
            this.mList = list;
        }

        @Override
        public void add(int location, E object) {
            try {
                this.mList.add(location, object);
            }
            finally {
                this.trim();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(int location, Collection<? extends E> collection) {
            try {
                boolean bl = this.mList.addAll(location, collection);
                return bl;
            }
            finally {
                this.trim();
            }
        }

        @Override
        public E get(int location) {
            return this.mList.get(location);
        }

        @Override
        public int indexOf(Object object) {
            return this.mList.indexOf(object);
        }

        @Override
        public int lastIndexOf(Object object) {
            return this.mList.lastIndexOf(object);
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.mList.listIterator();
        }

        @Override
        @NonNull
        public ListIterator<E> listIterator(int location) {
            return this.mList.listIterator(location);
        }

        @Override
        public E remove(int location) {
            return this.mList.remove(location);
        }

        @Override
        public E set(int location, E object) {
            return this.mList.set(location, object);
        }

        @Override
        @NonNull
        public List<E> subList(int start, int end) {
            return this.mList.subList(start, end);
        }
    }

    static class FIFOMaxSizeCollection<E>
    implements Collection<E> {
        int mMaxSize = 0;
        Collection<E> mCollection;

        public FIFOMaxSizeCollection(Collection<E> collection, int maxSize) {
            this.mCollection = collection;
            this.mMaxSize = maxSize;
        }

        public int getMaxSize() {
            return this.mMaxSize;
        }

        public void setMaxSize(int maxSize) {
            this.mMaxSize = maxSize;
            this.trim();
        }

        @Override
        public boolean add(E object) {
            try {
                boolean bl = this.mCollection.add(object);
                return bl;
            }
            finally {
                this.trim();
            }
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            try {
                boolean bl = this.mCollection.addAll(collection);
                return bl;
            }
            finally {
                this.trim();
            }
        }

        protected void trim() {
            Iterator<E> it = this.mCollection.iterator();
            while (it.hasNext() && this.size() > this.mMaxSize) {
                it.next();
                it.remove();
            }
        }

        @Override
        public void clear() {
            this.mCollection.clear();
        }

        @Override
        public boolean contains(Object object) {
            return this.mCollection.contains(object);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.mCollection.containsAll(collection);
        }

        @Override
        public boolean isEmpty() {
            return this.mCollection.isEmpty();
        }

        @Override
        @NonNull
        public Iterator<E> iterator() {
            return this.mCollection.iterator();
        }

        @Override
        public boolean remove(Object object) {
            return this.mCollection.remove(object);
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            return this.mCollection.removeAll(collection);
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            return this.mCollection.retainAll(collection);
        }

        @Override
        public int size() {
            return this.mCollection.size();
        }

        @Override
        @NonNull
        public Object[] toArray() {
            return this.mCollection.toArray();
        }

        @Override
        @NonNull
        public <T1> T1[] toArray(T1[] array) {
            return this.mCollection.toArray(array);
        }
    }
}

