/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.requests;

import com.shopgun.android.sdk.api.Endpoints;
import com.shopgun.android.sdk.model.Catalog;
import com.shopgun.android.sdk.model.Dealer;
import com.shopgun.android.sdk.model.HotspotMap;
import com.shopgun.android.sdk.model.Images;
import com.shopgun.android.sdk.model.Store;
import com.shopgun.android.sdk.model.interfaces.ICatalog;
import com.shopgun.android.sdk.model.interfaces.IDealer;
import com.shopgun.android.sdk.model.interfaces.IStore;
import com.shopgun.android.sdk.network.Request;
import com.shopgun.android.sdk.network.Response;
import com.shopgun.android.sdk.network.ShopGunError;
import com.shopgun.android.sdk.network.impl.JsonArrayRequest;
import com.shopgun.android.sdk.network.impl.JsonObjectRequest;
import com.shopgun.android.sdk.requests.LoaderRequest;
import com.shopgun.android.sdk.utils.Constants;
import com.shopgun.android.sdk.utils.IUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class RequestCreator {
    public static final String TAG = Constants.getTag(RequestCreator.class);

    protected RequestCreator() {
    }

    public static Request getStoreRequestOrNull(LoaderRequest request, IStore<?> item) {
        boolean needStore = item.getStore() == null;
        return needStore ? RequestCreator.getStoreRequest(request, item) : null;
    }

    public static Request getStoreRequest(final LoaderRequest request, final IStore<?> item) {
        return new JsonObjectRequest(Endpoints.storeId(item.getStoreId()), new Response.Listener<JSONObject>(){

            @Override
            public void onComplete(JSONObject response, ShopGunError error) {
                if (response != null) {
                    item.setStore(Store.fromJSON(response));
                } else {
                    request.addError(error);
                }
            }
        });
    }

    public static Request getStoresRequestOrNull(LoaderRequest request, List<? extends IStore<?>> list) {
        Set<String> ids = IUtils.getStoreIds(list);
        return ids.isEmpty() ? null : RequestCreator.getStoreRequest(ids, request, list);
    }

    public static Request getStoresRequest(LoaderRequest request, List<? extends IStore<?>> list) {
        Set<String> ids = IUtils.getStoreIds(list);
        return RequestCreator.getStoreRequest(ids, request, list);
    }

    private static Request getStoreRequest(Set<String> ids, final LoaderRequest request, final List<? extends IStore<?>> list) {
        JsonArrayRequest r = new JsonArrayRequest("/v2/stores", new Response.Listener<JSONArray>(){

            @Override
            public void onComplete(JSONArray response, ShopGunError error) {
                if (response != null) {
                    ArrayList<Store> stores = Store.fromJSON(response);
                    block0: for (IStore is : list) {
                        for (Store s : stores) {
                            if (!is.getStoreId().equals(s.getId())) continue;
                            is.setStore(s);
                            continue block0;
                        }
                    }
                } else {
                    request.addError(error);
                }
            }
        });
        r.setIds("store_ids", ids);
        return r;
    }

    public static Request getDealerRequestOrNull(LoaderRequest request, IDealer<?> item) {
        boolean needDealer = item.getDealer() == null;
        return needDealer ? RequestCreator.getDealerRequest(request, item) : null;
    }

    public static Request getDealerRequest(final LoaderRequest request, final IDealer<?> item) {
        return new JsonObjectRequest(Endpoints.dealerId(item.getDealerId()), new Response.Listener<JSONObject>(){

            @Override
            public void onComplete(JSONObject response, ShopGunError error) {
                if (response != null) {
                    item.setDealer(Dealer.fromJSON(response));
                } else {
                    request.addError(error);
                }
            }
        });
    }

    public static Request getDealersRequestOrNull(LoaderRequest request, List<? extends IDealer<?>> list) {
        Set<String> ids = IUtils.getDealerIds(list);
        return ids.isEmpty() ? null : RequestCreator.getDealersRequest(ids, request, list);
    }

    public static Request getDealersRequest(LoaderRequest request, List<? extends IDealer<?>> list) {
        Set<String> ids = IUtils.getDealerIds(list);
        return RequestCreator.getDealersRequest(ids, request, list);
    }

    private static Request getDealersRequest(Set<String> ids, final LoaderRequest request, final List<? extends IDealer<?>> list) {
        JsonArrayRequest r = new JsonArrayRequest("/v2/dealers", new Response.Listener<JSONArray>(){

            @Override
            public void onComplete(JSONArray response, ShopGunError error) {
                if (response != null) {
                    List<Dealer> dealers = Dealer.fromJSON(response);
                    block0: for (IDealer idealer : list) {
                        for (Dealer d : dealers) {
                            if (!idealer.getDealerId().equals(d.getId())) continue;
                            idealer.setDealer(d);
                            continue block0;
                        }
                    }
                } else {
                    request.addError(error);
                }
            }
        });
        r.setIds("dealer_ids", ids);
        return r;
    }

    public static List<Request> getPagesListRequestOrEmpty(LoaderRequest request, List<Catalog> catalogs) {
        ArrayList<Request> list = new ArrayList<Request>();
        for (Catalog c : catalogs) {
            Request r = RequestCreator.getPagesRequestOrNull(request, c);
            if (r == null) continue;
            list.add(r);
        }
        return list;
    }

    public static List<Request> getPagesListRequest(LoaderRequest request, List<Catalog> catalogs) {
        ArrayList<Request> list = new ArrayList<Request>();
        for (Catalog c : catalogs) {
            list.add(RequestCreator.getPagesRequestOrNull(request, c));
        }
        return list;
    }

    public static Request getPagesRequestOrNull(LoaderRequest request, Catalog c) {
        boolean needPages = c.getPages() == null || c.getPages().isEmpty();
        return needPages ? RequestCreator.getPagesRequest(request, c) : null;
    }

    public static Request getPagesRequest(final LoaderRequest request, final Catalog c) {
        return new JsonArrayRequest(Endpoints.catalogPages(c.getId()), new Response.Listener<JSONArray>(){

            @Override
            public void onComplete(JSONArray response, ShopGunError error) {
                if (response != null) {
                    c.setPages(Images.fromJSON(response));
                } else {
                    request.addError(error);
                }
            }
        });
    }

    public static List<Request> getHotspotsListRequestOrEmpty(LoaderRequest request, List<Catalog> catalogs) {
        ArrayList<Request> list = new ArrayList<Request>();
        for (Catalog c : catalogs) {
            Request r = RequestCreator.getHotspotsRequestOrNull(request, c);
            if (r == null) continue;
            list.add(r);
        }
        return list;
    }

    public static List<Request> getHotspotsListRequest(LoaderRequest request, List<Catalog> catalogs) {
        ArrayList<Request> list = new ArrayList<Request>();
        for (Catalog c : catalogs) {
            list.add(RequestCreator.getHotspotsRequest(request, c));
        }
        return list;
    }

    public static Request getHotspotsRequestOrNull(LoaderRequest request, Catalog c) {
        boolean needHotspots = c.getHotspots() == null;
        return needHotspots ? RequestCreator.getHotspotsRequest(request, c) : null;
    }

    public static Request getHotspotsRequest(final LoaderRequest request, final Catalog c) {
        return new JsonArrayRequest(Endpoints.catalogHotspots(c.getId()), new Response.Listener<JSONArray>(){

            @Override
            public void onComplete(JSONArray response, ShopGunError error) {
                if (response != null) {
                    c.setHotspots(HotspotMap.fromJSON(c.getDimension(), response));
                } else {
                    request.addError(error);
                }
            }
        });
    }

    public static Request createCatalogRequest(LoaderRequest request, ICatalog<?> item, boolean replace) {
        return replace || item.getCatalog() == null ? RequestCreator.createCatalogRequest(request, item) : null;
    }

    public static Request createCatalogRequest(final LoaderRequest request, final ICatalog<?> item) {
        return new JsonObjectRequest(Endpoints.catalogId(item.getCatalogId()), new Response.Listener<JSONObject>(){

            @Override
            public void onComplete(JSONObject response, ShopGunError error) {
                if (response != null) {
                    item.setCatalog(Catalog.fromJSON(response));
                } else {
                    request.addError(error);
                }
            }
        });
    }

    public static Request createCatalogRequest(LoaderRequest request, List<? extends ICatalog<?>> list) {
        return RequestCreator.createCatalogRequest(request, list, false);
    }

    public static Request createCatalogRequest(LoaderRequest request, List<? extends ICatalog<?>> list, boolean replace) {
        Set<String> ids = IUtils.getCatalogIds(list, replace);
        return ids.isEmpty() ? null : RequestCreator.createCatalogRequest(ids, request, list);
    }

    private static Request createCatalogRequest(Set<String> ids, final LoaderRequest request, final List<? extends ICatalog<?>> list) {
        JsonArrayRequest r = new JsonArrayRequest("/v2/catalogs", new Response.Listener<JSONArray>(){

            @Override
            public void onComplete(JSONArray response, ShopGunError error) {
                if (response != null) {
                    List<Catalog> stores = Catalog.fromJSON(response);
                    block0: for (ICatalog is : list) {
                        for (Catalog s : stores) {
                            if (!is.getCatalogId().equals(s.getId())) continue;
                            is.setCatalog(s);
                            continue block0;
                        }
                    }
                } else {
                    request.addError(error);
                }
            }
        });
        r.setIds("catalog_ids", ids);
        return r;
    }
}

