/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.requests;

import com.shopgun.android.sdk.network.Cache;
import com.shopgun.android.sdk.network.Delivery;
import com.shopgun.android.sdk.network.Request;
import com.shopgun.android.sdk.network.RequestQueue;
import com.shopgun.android.sdk.network.Response;
import com.shopgun.android.sdk.network.ShopGunError;
import com.shopgun.android.sdk.network.impl.JsonObjectRequest;
import com.shopgun.android.sdk.requests.InternalOkError;
import com.shopgun.android.sdk.requests.LoaderDelivery;
import com.shopgun.android.sdk.requests.LoaderRequest;
import com.shopgun.android.sdk.requests.ModelLoaderRequest;
import com.shopgun.android.sdk.requests.ModelRequestTools;
import com.shopgun.android.sdk.utils.Constants;
import java.util.ArrayList;
import org.json.JSONObject;

public abstract class ModelRequest<T>
extends JsonObjectRequest
implements Delivery {
    public static final String TAG = Constants.getTag(ModelRequest.class);
    private final ModelLoaderRequest<T> mLoaderRequest;
    private final LoaderRequest.Listener<T> mLoaderListener;
    private final LoaderDelivery<T> mDelivery;

    public ModelRequest(String url, LoaderRequest.Listener<T> listener) {
        this(url, null, listener);
    }

    public ModelRequest(String url, ModelLoaderRequest<T> request, LoaderRequest.Listener<T> listener) {
        super(url, (Response.Listener<JSONObject>)null);
        this.mLoaderRequest = request;
        this.mLoaderListener = listener;
        this.mDelivery = new LoaderDelivery<T>(this.mLoaderListener);
    }

    public ModelLoaderRequest<T> getLoaderRequest() {
        return this.mLoaderRequest;
    }

    @Override
    public synchronized Request setRequestQueue(RequestQueue requestQueue) {
        super.setRequestQueue(requestQueue);
        if (this.getTag() == null) {
            this.setTag(new Object());
        }
        super.setDelivery(this);
        return this;
    }

    @Override
    public Response<JSONObject> parseCache(Cache c) {
        if (this.mLoaderRequest != null && this.mLoaderRequest.getData() != null) {
            return Response.fromError(new InternalOkError());
        }
        return super.parseCache(c);
    }

    @Override
    public Request setDelivery(Delivery d) {
        throw new RuntimeException(new IllegalAccessException("Custom delivery for model requests is not allowed"));
    }

    public abstract T parse(JSONObject var1);

    @Override
    public synchronized void cancel() {
        super.cancel();
        if (this.mLoaderRequest != null) {
            this.mLoaderRequest.cancel();
        }
    }

    @Override
    public synchronized void postResponse(Request<?> request, Response<?> response) {
        request.addEvent("post-response");
        if (this.isCanceled()) {
            request.addEvent("loaderRequest-have-been-canceled");
        } else if (response.isSuccess()) {
            request.addEvent("parsing-response-to-model-object");
            T data = this.parse((JSONObject)response.result);
            boolean intermediate = ModelRequestTools.runLoader(this, this.mLoaderRequest, data, this.getRequestQueue());
            this.mDelivery.deliver((Request)this, response, data, new ArrayList<ShopGunError>(0), intermediate);
        } else if (response.error instanceof InternalOkError) {
            request.addEvent("running-loader-request-with-original-data");
            Object data = this.mLoaderRequest.getData();
            boolean intermediate = ModelRequestTools.runLoader(this, this.mLoaderRequest, data, this.getRequestQueue());
            this.mDelivery.deliver((Request)this, response, data, new ArrayList<ShopGunError>(0), intermediate);
        } else {
            this.mDelivery.deliver((Request)this, response, null, response.error, false);
        }
    }

    protected boolean loadDealer() {
        return this.mLoaderRequest.loadDealer();
    }

    protected void loadDealer(boolean dealer) {
        this.mLoaderRequest.loadDealer(dealer);
    }

    protected boolean loadHotspots() {
        return this.mLoaderRequest.loadHotspots();
    }

    protected void loadHotspots(boolean hotspots) {
        this.mLoaderRequest.loadHotspots(hotspots);
    }

    protected boolean loadPages() {
        return this.mLoaderRequest.loadPages();
    }

    protected void loadPages(boolean pages) {
        this.mLoaderRequest.loadPages(pages);
    }

    protected boolean loadStore() {
        return this.mLoaderRequest.loadStore();
    }

    protected void loadStore(boolean store) {
        this.mLoaderRequest.loadStore(store);
    }

    protected boolean loadCatalog() {
        return this.mLoaderRequest.loadCatalog();
    }

    protected void loadCatalog(boolean catalog) {
        this.mLoaderRequest.loadCatalog(catalog);
    }
}

