/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.requests;

import com.shopgun.android.sdk.model.Catalog;
import com.shopgun.android.sdk.model.interfaces.ICatalog;
import com.shopgun.android.sdk.model.interfaces.IDealer;
import com.shopgun.android.sdk.model.interfaces.IStore;
import com.shopgun.android.sdk.network.Request;
import com.shopgun.android.sdk.requests.LoaderRequest;
import com.shopgun.android.sdk.requests.RequestCreator;
import com.shopgun.android.sdk.utils.Constants;
import java.util.ArrayList;
import java.util.List;

public abstract class ModelListLoaderRequest<T>
extends LoaderRequest<T> {
    public static final String TAG = Constants.getTag(ModelListLoaderRequest.class);
    private boolean mPages = false;
    private boolean mDealer = false;
    private boolean mStore = false;
    private boolean mHotspots = false;
    private boolean mCatalog = false;

    public ModelListLoaderRequest(LoaderRequest.Listener<T> l) {
        super(l);
    }

    public ModelListLoaderRequest(T data, LoaderRequest.Listener<T> l) {
        super(data, l);
    }

    protected boolean loadPages() {
        return this.mPages;
    }

    protected void loadPages(boolean pages) {
        this.mPages = pages;
    }

    protected boolean loadDealer() {
        return this.mDealer;
    }

    protected void loadDealer(boolean dealer) {
        this.mDealer = dealer;
    }

    protected boolean loadStore() {
        return this.mStore;
    }

    protected void loadStore(boolean store) {
        this.mStore = store;
    }

    protected boolean loadHotspots() {
        return this.mHotspots;
    }

    protected void loadHotspots(boolean hotspots) {
        this.mHotspots = hotspots;
    }

    protected boolean loadCatalog() {
        return this.mCatalog;
    }

    protected void loadCatalog(boolean catalog) {
        this.mCatalog = catalog;
    }

    @Override
    public List<Request> createRequests(T data) {
        return data instanceof List ? this.getReqs((List)data) : new ArrayList();
    }

    List<Request> getReqs(List<?> data) {
        ArrayList<Request> requests = new ArrayList<Request>();
        if (data.isEmpty()) {
            return requests;
        }
        Object item = data.get(0);
        if (this.mPages && item instanceof Catalog) {
            requests.addAll(RequestCreator.getPagesListRequestOrEmpty(this, data));
        }
        if (this.mStore && item instanceof IStore) {
            requests.add(RequestCreator.getStoresRequestOrNull(this, data));
        }
        if (this.mDealer && item instanceof IDealer) {
            requests.add(RequestCreator.getDealersRequestOrNull(this, data));
        }
        if (this.mHotspots && item instanceof Catalog) {
            requests.addAll(RequestCreator.getHotspotsListRequestOrEmpty(this, data));
        }
        if (this.mCatalog && item instanceof ICatalog) {
            requests.add(RequestCreator.createCatalogRequest((LoaderRequest)this, data, true));
        }
        return requests;
    }
}

