/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.requests;

import android.os.Handler;
import android.os.Looper;
import com.shopgun.android.sdk.network.Delivery;
import com.shopgun.android.sdk.network.Request;
import com.shopgun.android.sdk.network.Response;
import com.shopgun.android.sdk.network.ShopGunError;
import com.shopgun.android.sdk.requests.LoaderRequest;
import com.shopgun.android.sdk.utils.Constants;
import java.util.ArrayList;
import java.util.List;

public class LoaderDelivery<T> {
    public static final String TAG = Constants.getTag(LoaderDelivery.class);
    Handler mHandler = new Handler(Looper.getMainLooper());
    LoaderRequest.Listener<T> mListener;

    public LoaderDelivery(LoaderRequest.Listener<T> listener) {
        this.mListener = listener;
    }

    public void deliver(Request request, Response response, T data, List<ShopGunError> errors, boolean intermediate) {
        this.deliverFinishRequestAndPostBack(request, response, data, errors, intermediate);
    }

    public void deliver(Request request, Response response, T data, ShopGunError error, boolean intermediate) {
        ArrayList<ShopGunError> errors = new ArrayList<ShopGunError>();
        errors.add(error);
        this.deliverFinishRequestAndPostBack(request, response, data, errors, intermediate);
    }

    private void deliverFinishRequestAndPostBack(Request<?> request, Response response, T data, List<ShopGunError> errors, boolean intermediate) {
        new Delivery.DeliveryRunnable(request, response).run();
        this.mHandler.post((Runnable)new LoaderRequestPostBackRunnable(request, data, errors, intermediate));
    }

    private class LoaderRequestPostBackRunnable
    implements Runnable {
        private final Request<?> mRequest;
        private final T mData;
        private final List<ShopGunError> mErrors;
        private final boolean mIntermediate;

        public LoaderRequestPostBackRunnable(Request<?> request, T mData, List<ShopGunError> mErrors, boolean intermediate) {
            this.mRequest = request;
            this.mData = mData;
            this.mErrors = mErrors;
            this.mIntermediate = intermediate;
        }

        @Override
        public void run() {
            if (this.mRequest.isCanceled()) {
                this.mRequest.finish("cancelled-at-delivery");
            } else if (this.mIntermediate) {
                LoaderDelivery.this.mListener.onRequestIntermediate(this.mData, this.mErrors);
            } else {
                LoaderDelivery.this.mListener.onRequestComplete(this.mData, this.mErrors);
            }
        }
    }
}

