/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.pagedpublicationkit.impl.apiv2;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.View;
import android.widget.FrameLayout;
import com.shopgun.android.sdk.pagedpublicationkit.PagedPublicationFragment;
import com.shopgun.android.sdk.pagedpublicationkit.PagedPublicationHotspot;
import com.shopgun.android.sdk.pagedpublicationkit.PagedPublicationOverlay;
import com.shopgun.android.sdk.pagedpublicationkit.impl.apiv2.CatalogHotspotView;
import java.util.ArrayList;
import java.util.List;

@SuppressLint(value={"ViewConstructor"})
public class CatalogSpreadLayout
extends FrameLayout
implements PagedPublicationOverlay {
    public static final String TAG = CatalogSpreadLayout.class.getSimpleName();
    List<HotspotUIController> mHotspots = new ArrayList<HotspotUIController>();
    int[] mPages;

    public CatalogSpreadLayout(Context context, int[] pages) {
        super(context);
        this.mPages = pages;
    }

    @Override
    public void showHotspots(PagedPublicationFragment.PublicationTapInfo info) {
        if (info != null && info.hasHotspots()) {
            HotspotUIController huc = new HotspotUIController(info);
            this.mHotspots.add(huc);
            huc.display();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)width, (int)Integer.MIN_VALUE);
        int childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)height, (int)Integer.MIN_VALUE);
        this.measureChildren(childWidthMeasureSpec, childHeightMeasureSpec);
        this.setMeasuredDimension(width, height);
    }

    class HotspotUIController {
        final PagedPublicationFragment.PublicationTapInfo mInfo;
        final List<View> mViews;

        HotspotUIController(PagedPublicationFragment.PublicationTapInfo info) {
            this.mInfo = info;
            this.mViews = new ArrayList<View>();
            for (PagedPublicationHotspot h : info.getHotspots()) {
                CatalogHotspotView view = new CatalogHotspotView(CatalogSpreadLayout.this.getContext(), h, CatalogSpreadLayout.this.mPages);
                CatalogSpreadLayout.this.addView(view);
                this.mViews.add(view);
            }
        }

        void display() {
            for (View v : this.mViews) {
                v.getAnimation().startNow();
            }
        }
    }
}

