/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.pagedpublicationkit.impl.apiv2;

import android.os.Parcel;
import android.os.Parcelable;
import com.shopgun.android.sdk.model.Catalog;
import com.shopgun.android.sdk.model.Dimension;
import com.shopgun.android.sdk.pagedpublicationkit.PagedPublication;

public class CatalogPublication
implements PagedPublication,
Parcelable {
    String mId;
    int mBackgroundColor;
    int mPageCount;
    float mAspectRatio;
    String mOwnerId;
    public static final Parcelable.Creator<CatalogPublication> CREATOR = new Parcelable.Creator<CatalogPublication>(){

        public CatalogPublication createFromParcel(Parcel source) {
            return new CatalogPublication(source);
        }

        public CatalogPublication[] newArray(int size) {
            return new CatalogPublication[size];
        }
    };

    public CatalogPublication(String catalogId) {
        this.mId = catalogId;
    }

    public CatalogPublication(Catalog catalog) {
        this.mId = catalog.getId();
        this.mBackgroundColor = catalog.getBranding().getColor();
        this.mPageCount = catalog.getPageCount();
        this.mAspectRatio = this.getAspectRatio(catalog);
        this.mOwnerId = catalog.getDealerId();
    }

    @Override
    public String getId() {
        return this.mId;
    }

    @Override
    public int getBackgroundColor() {
        return this.mBackgroundColor;
    }

    @Override
    public int getPageCount() {
        return this.mPageCount;
    }

    @Override
    public float getAspectRatio() {
        return this.mAspectRatio;
    }

    private float getAspectRatio(Catalog catalog) {
        Dimension d = catalog.getDimension();
        if (d != null) {
            float width = d.getWidth() == null ? 1.0f : d.getWidth().floatValue();
            float height = d.getHeight() == null ? 1.0f : d.getHeight().floatValue();
            return width / height;
        }
        return 1.0f;
    }

    @Override
    public String getOwnerId() {
        return this.mOwnerId;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mId);
        dest.writeInt(this.mBackgroundColor);
        dest.writeInt(this.mPageCount);
        dest.writeFloat(this.mAspectRatio);
        dest.writeString(this.mOwnerId);
    }

    protected CatalogPublication(Parcel in) {
        this.mId = in.readString();
        this.mBackgroundColor = in.readInt();
        this.mPageCount = in.readInt();
        this.mAspectRatio = in.readFloat();
        this.mOwnerId = in.readString();
    }
}

