/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.pagedpublicationkit.impl.apiv2;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.shopgun.android.sdk.model.Images;
import com.shopgun.android.sdk.pagedpublicationkit.PagedPublicationPage;
import com.shopgun.android.utils.MemoryUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class CatalogPage
implements PagedPublicationPage,
Parcelable {
    private String mThumbUrl;
    private String mViewUrl;
    private String mZoomUrl;
    private int mPageIndex;
    private Bitmap.Config mBitmapConfig;
    private float mAspectRatio;
    public static final Parcelable.Creator<CatalogPage> CREATOR = new Parcelable.Creator<CatalogPage>(){

        public CatalogPage createFromParcel(Parcel source) {
            return new CatalogPage(source);
        }

        public CatalogPage[] newArray(int size) {
            return new CatalogPage[size];
        }
    };

    public static List<CatalogPage> from(Context ctx, List<Images> images, float aspectRatio) {
        int maxMem = MemoryUtils.getMaxHeap((Context)ctx);
        ArrayList<CatalogPage> pages = new ArrayList<CatalogPage>(images.size());
        for (int j = 0; j < images.size(); ++j) {
            Images i = images.get(j);
            CatalogPage page = maxMem >= 96 ? new CatalogPage(j, i.getThumb(), i.getView(), i.getZoom(), aspectRatio, Bitmap.Config.ARGB_8888) : (maxMem >= 48 ? new CatalogPage(j, i.getThumb(), i.getView(), i.getZoom(), aspectRatio, Bitmap.Config.RGB_565) : new CatalogPage(j, i.getThumb(), i.getView(), i.getView(), aspectRatio, Bitmap.Config.RGB_565));
            pages.add(page);
        }
        return pages;
    }

    public CatalogPage(int pageIndex, String thumbUrl, String viewUrl, String zoomUrl, float aspectRatio, Bitmap.Config bitmapConfig) {
        this.mPageIndex = pageIndex;
        this.mThumbUrl = thumbUrl;
        this.mViewUrl = viewUrl;
        this.mZoomUrl = zoomUrl;
        this.mBitmapConfig = bitmapConfig;
        this.mAspectRatio = aspectRatio;
    }

    @Override
    @NonNull
    public String getUrl(PagedPublicationPage.Size size) {
        switch (size) {
            case THUMB: {
                return this.mThumbUrl;
            }
            case VIEW: {
                return this.mViewUrl;
            }
            case ZOOM: {
                return this.mZoomUrl;
            }
        }
        return this.mViewUrl;
    }

    @Override
    public int getPageIndex() {
        return this.mPageIndex;
    }

    @Override
    @NonNull
    public Bitmap.Config getBitmapConfig(PagedPublicationPage.Size size) {
        return null;
    }

    @Override
    public boolean allowResize(PagedPublicationPage.Size size) {
        return size == PagedPublicationPage.Size.VIEW;
    }

    @Override
    public float getAspectRatio() {
        return this.mAspectRatio;
    }

    public String toString() {
        String format = "CatalogPage[ page:%s, viewUrl:%s, bitmapConfig:%s, aspectRatio:%.2f";
        return String.format(Locale.US, format, this.mPageIndex, this.mViewUrl, this.mBitmapConfig, Float.valueOf(this.mAspectRatio));
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mViewUrl);
        dest.writeString(this.mZoomUrl);
        dest.writeInt(this.mPageIndex);
        dest.writeInt(this.mBitmapConfig == null ? -1 : this.mBitmapConfig.ordinal());
        dest.writeFloat(this.mAspectRatio);
    }

    protected CatalogPage(Parcel in) {
        this.mViewUrl = in.readString();
        this.mZoomUrl = in.readString();
        this.mPageIndex = in.readInt();
        int tmpMBitmapConfig = in.readInt();
        this.mBitmapConfig = tmpMBitmapConfig == -1 ? null : Bitmap.Config.values()[tmpMBitmapConfig];
        this.mAspectRatio = in.readFloat();
    }
}

