/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.pagedpublicationkit.impl.apiv2;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Rect;
import android.graphics.RectF;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import com.shopgun.android.sdk.R;
import com.shopgun.android.sdk.pagedpublicationkit.PagedPublicationHotspot;

@SuppressLint(value={"ViewConstructor"})
public class CatalogHotspotView
extends View {
    public static final String TAG = CatalogHotspotView.class.getSimpleName();
    PagedPublicationHotspot mHotspot;
    int[] mPages;
    RectF mBounds;
    private boolean outPlayed = false;

    public CatalogHotspotView(Context context, PagedPublicationHotspot hotspot, int[] pages) {
        super(context);
        this.mHotspot = hotspot;
        this.mPages = pages;
        this.mBounds = this.mHotspot.getBoundsForPages(this.mPages);
        this.setBackgroundResource(R.drawable.sgn_pagedpubkit_hotspot_bg);
        this.setAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.sgn_pagedpubkit_hotspot_in));
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        Rect rect = CatalogHotspotView.getScaledRect(this.mBounds, width, height);
        ((ViewGroup.MarginLayoutParams)this.getLayoutParams()).leftMargin = rect.left;
        ((ViewGroup.MarginLayoutParams)this.getLayoutParams()).topMargin = rect.top;
        widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)rect.width(), (int)0x40000000);
        heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)rect.height(), (int)0x40000000);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    private static Rect getScaledRect(RectF rect, int width, int height) {
        Rect r = new Rect();
        r.left = Math.round(rect.left * (float)width);
        r.top = Math.round(rect.top * (float)height);
        r.right = Math.round(rect.right * (float)width);
        r.bottom = Math.round(rect.bottom * (float)height);
        return r;
    }

    protected void onAnimationEnd() {
        super.onAnimationEnd();
        if (!this.outPlayed) {
            this.outPlayed = true;
            this.startAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.sgn_pagedpubkit_hotspot_out));
        } else {
            final ViewGroup parent = (ViewGroup)this.getParent();
            if (parent != null) {
                final CatalogHotspotView view = this;
                parent.post(new Runnable(){

                    @Override
                    public void run() {
                        parent.removeView(view);
                    }
                });
            }
        }
    }
}

