/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.pagedpublicationkit.impl.apiv2;

import android.content.res.Configuration;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.View;
import android.view.ViewGroup;
import com.shopgun.android.materialcolorcreator.MaterialColorImpl;
import com.shopgun.android.sdk.ShopGun;
import com.shopgun.android.sdk.model.Catalog;
import com.shopgun.android.sdk.model.HotspotMap;
import com.shopgun.android.sdk.network.Request;
import com.shopgun.android.sdk.network.ShopGunError;
import com.shopgun.android.sdk.pagedpublicationkit.PagedPublication;
import com.shopgun.android.sdk.pagedpublicationkit.PagedPublicationConfiguration;
import com.shopgun.android.sdk.pagedpublicationkit.PagedPublicationHotspotCollection;
import com.shopgun.android.sdk.pagedpublicationkit.PagedPublicationPage;
import com.shopgun.android.sdk.pagedpublicationkit.PublicationException;
import com.shopgun.android.sdk.pagedpublicationkit.impl.IntroOutroConfiguration;
import com.shopgun.android.sdk.pagedpublicationkit.impl.SpreadPropertyImpl;
import com.shopgun.android.sdk.pagedpublicationkit.impl.apiv2.CatalogPage;
import com.shopgun.android.sdk.pagedpublicationkit.impl.apiv2.CatalogPageView;
import com.shopgun.android.sdk.pagedpublicationkit.impl.apiv2.CatalogPublication;
import com.shopgun.android.sdk.pagedpublicationkit.impl.apiv2.CatalogSpreadLayout;
import com.shopgun.android.sdk.requests.LoaderRequest;
import com.shopgun.android.sdk.requests.impl.CatalogLoaderRequest;
import com.shopgun.android.sdk.requests.impl.CatalogRequest;
import com.shopgun.android.utils.enums.Orientation;
import com.shopgun.android.verso.VersoSpreadProperty;
import java.util.ArrayList;
import java.util.List;

public class CatalogConfiguration
extends IntroOutroConfiguration {
    public static final String TAG = CatalogConfiguration.class.getSimpleName();
    private Catalog mCatalog;
    private String mCatalogId;
    private int mLoadingTextColor;
    private CatalogPublication mPublication;
    private List<CatalogPage> mPages;
    private HotspotMap mHotspots;
    private Orientation mOrientation = Orientation.PORTRAIT;
    private Request mCatalogRequest;
    public static final Parcelable.Creator<CatalogConfiguration> CREATOR = new Parcelable.Creator<CatalogConfiguration>(){

        public CatalogConfiguration createFromParcel(Parcel source) {
            return new CatalogConfiguration(source);
        }

        public CatalogConfiguration[] newArray(int size) {
            return new CatalogConfiguration[size];
        }
    };

    public CatalogConfiguration(String catalogId) {
        this.mCatalogId = catalogId;
    }

    public CatalogConfiguration(Catalog catalog) {
        this.mCatalog = catalog;
        this.ensureData();
    }

    public void onConfigurationChanged(Configuration newConfig) {
        this.mOrientation = Orientation.fromConfiguration((Configuration)newConfig);
    }

    @Override
    public Orientation getOrientation() {
        return this.mOrientation;
    }

    @Override
    public int getPublicationPageCount() {
        return this.mCatalog == null ? 0 : this.mCatalog.getPageCount();
    }

    public Catalog getCatalog() {
        return this.mCatalog;
    }

    public int getSpreadMargin() {
        return 0;
    }

    @Override
    public VersoSpreadProperty getPublicationSpreadProperty(int spreadPosition, int[] pages) {
        return SpreadPropertyImpl.getCatalogSpread(pages);
    }

    @Override
    public View getPublicationPageView(ViewGroup container, int publicationPage) {
        CatalogPage catalogPage = this.mPages.get(publicationPage);
        return new CatalogPageView(container.getContext(), catalogPage, this.mLoadingTextColor);
    }

    @Override
    public View getPublicationSpreadOverlay(ViewGroup container, int[] publicationPages) {
        return new CatalogSpreadLayout(container.getContext(), publicationPages);
    }

    public boolean hasData() {
        return this.mPublication != null && this.mPages != null;
    }

    @Override
    public PagedPublication getPublication() {
        return this.mPublication;
    }

    @Override
    public boolean hasPublication() {
        return this.mPublication != null;
    }

    @Override
    public List<? extends PagedPublicationPage> getPages() {
        return this.mPages;
    }

    @Override
    public boolean hasPages() {
        return this.mPages != null;
    }

    @Override
    public PagedPublicationHotspotCollection getHotspotCollection() {
        return this.mHotspots;
    }

    @Override
    public boolean hasHotspotCollection() {
        return this.mHotspots != null;
    }

    @Override
    public void load(PagedPublicationConfiguration.OnLoadComplete callback) {
        if (this.isLoading()) {
            this.cancel();
        }
        CatalogListener listener = new CatalogListener(callback);
        if (this.mCatalog != null) {
            CatalogLoaderRequest r = new CatalogLoaderRequest(this.mCatalog, listener);
            r.loadPages(this.mPages == null);
            r.loadHotspots(this.mHotspots == null);
            this.mCatalogRequest = r;
            listener.onRequestIntermediate(this.mCatalog, (List<ShopGunError>)new ArrayList<ShopGunError>());
        } else {
            CatalogRequest r = new CatalogRequest(this.mCatalogId, (LoaderRequest.Listener<Catalog>)listener);
            r.loadPages(this.mPages == null);
            r.loadHotspots(this.mHotspots == null);
            this.mCatalogRequest = r;
        }
        ShopGun.getInstance().add(this.mCatalogRequest);
    }

    @Override
    public boolean isLoading() {
        return this.mCatalogRequest != null && (!this.mCatalogRequest.isFinished() || !this.mCatalogRequest.isCanceled());
    }

    @Override
    public void cancel() {
        if (this.mCatalogRequest != null) {
            this.mCatalogRequest.cancel();
        }
        this.mCatalogRequest = null;
    }

    @Override
    public String getSource() {
        return "legacy";
    }

    private void ensureData() {
        if (this.mCatalog != null) {
            this.mCatalogId = this.mCatalog.getId();
            int color = this.mCatalog.getBranding().getColor();
            this.mLoadingTextColor = new MaterialColorImpl(color).getPrimaryText();
            this.mPublication = new CatalogPublication(this.mCatalog);
            if (this.mCatalog.getPages() != null) {
                this.mPages = CatalogPage.from(ShopGun.getInstance().getContext(), this.mCatalog.getPages(), this.mPublication.getAspectRatio());
            }
            if (this.mCatalog.getHotspots() != null) {
                this.mHotspots = this.mCatalog.getHotspots();
            }
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.mCatalog, flags);
        dest.writeString(this.mCatalogId);
        dest.writeInt(this.mOrientation == null ? -1 : this.mOrientation.ordinal());
    }

    protected CatalogConfiguration(Parcel in) {
        this.mCatalog = (Catalog)in.readParcelable(Catalog.class.getClassLoader());
        this.mCatalogId = in.readString();
        int tmpMOrientation = in.readInt();
        this.mOrientation = tmpMOrientation == -1 ? null : Orientation.values()[tmpMOrientation];
    }

    private class CatalogListener
    implements LoaderRequest.Listener<Catalog> {
        private PagedPublicationConfiguration.OnLoadComplete mCallback;

        public CatalogListener(PagedPublicationConfiguration.OnLoadComplete callback) {
            this.mCallback = callback;
        }

        @Override
        public void onRequestComplete(Catalog response, List<ShopGunError> errors) {
            this.ensurePublicationData(response, errors, true);
        }

        @Override
        public void onRequestIntermediate(Catalog response, List<ShopGunError> errors) {
            this.ensurePublicationData(response, errors, false);
        }

        private void ensurePublicationData(Catalog catalog, List<ShopGunError> errors, boolean complete) {
            if (catalog == null) {
                this.callCatalogError(errors);
                return;
            }
            if (CatalogConfiguration.this.mPublication == null) {
                CatalogConfiguration.this.mCatalog = catalog;
                CatalogConfiguration.this.ensureData();
                this.mCallback.onPublicationLoaded(CatalogConfiguration.this.mPublication);
            }
            if (CatalogConfiguration.this.mPages == null && catalog.getPages() != null) {
                CatalogConfiguration.this.mPages = CatalogPage.from(ShopGun.getInstance().getContext(), catalog.getPages(), CatalogConfiguration.this.mPublication.getAspectRatio());
                catalog.setPages(null);
                this.mCallback.onPagesLoaded(CatalogConfiguration.this.mPages);
            }
            if (CatalogConfiguration.this.mHotspots == null && catalog.getHotspots() != null) {
                HotspotMap hotspotMap = catalog.getHotspots();
                catalog.setHotspots(null);
                CatalogConfiguration.this.mHotspots = hotspotMap;
                this.mCallback.onHotspotsLoaded(CatalogConfiguration.this.mHotspots);
            }
            if (complete && (CatalogConfiguration.this.mPublication == null || CatalogConfiguration.this.mPages == null)) {
                this.callCatalogError(errors);
            }
        }

        private void callCatalogError(List<ShopGunError> errors) {
            ArrayList<PublicationException> tmp = new ArrayList<PublicationException>(errors.size());
            for (ShopGunError e : errors) {
                tmp.add(new PublicationException(e));
            }
            this.mCallback.onError(tmp);
        }
    }
}

