/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.pagedpublicationkit.impl;

import android.animation.Animator;
import android.animation.ArgbEvaluator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.support.annotation.ColorInt;
import android.support.annotation.IntRange;
import android.support.v7.widget.AppCompatTextView;
import android.util.AttributeSet;
import com.shopgun.android.utils.ColorUtils;

public class PulsatingTextView
extends AppCompatTextView {
    public static final String TAG = PulsatingTextView.class.getSimpleName();
    ValueAnimator mValueAnimator;
    int mColorFrom;
    int mColorTo;
    boolean mCancelled = false;

    public PulsatingTextView(Context context) {
        super(context);
    }

    public PulsatingTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public PulsatingTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setPulseColors(int colorFrom, int colorTo) {
        this.mColorFrom = colorFrom;
        this.mColorTo = colorTo;
        this.setTextColor(this.mColorFrom);
    }

    public void setPulseColors(@ColorInt int color, @IntRange(from=0L, to=255L) int fromAlpha, @IntRange(from=0L, to=255L) int toAlpha) {
        if (!(0 > fromAlpha && fromAlpha > 255 || 0 > toAlpha && toAlpha > 255)) {
            this.setPulseColors(ColorUtils.setAlphaComponent((int)color, (int)fromAlpha), ColorUtils.setAlphaComponent((int)color, (int)toAlpha));
        }
    }

    public void startPulse() {
        this.cancelPulse();
        this.mCancelled = false;
        this.mValueAnimator = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{this.mColorFrom, this.mColorTo});
        this.mValueAnimator.setDuration(1000L);
        this.mValueAnimator.setRepeatCount(-1);
        this.mValueAnimator.setRepeatMode(2);
        CancelAnimationListener l = new CancelAnimationListener();
        this.mValueAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)l);
        this.mValueAnimator.addListener((Animator.AnimatorListener)l);
        this.mValueAnimator.start();
    }

    public void cancelPulse(boolean onNextIteration) {
        this.mCancelled = true;
        if (!onNextIteration) {
            this.cancelPulse();
        }
    }

    private void cancelPulse() {
        if (this.mValueAnimator != null) {
            this.mValueAnimator.cancel();
            this.setTextColor(this.mColorFrom);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.startPulse();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.cancelPulse(false);
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        switch (visibility) {
            case 4: 
            case 8: {
                this.cancelPulse();
                break;
            }
            case 0: {
                this.startPulse();
            }
        }
    }

    private class CancelAnimationListener
    implements Animator.AnimatorListener,
    ValueAnimator.AnimatorUpdateListener {
        private CancelAnimationListener() {
        }

        public void onAnimationUpdate(ValueAnimator animation) {
            int color = (Integer)animation.getAnimatedValue();
            PulsatingTextView.this.setTextColor(color);
        }

        public void onAnimationRepeat(Animator animation) {
            if (PulsatingTextView.this.mCancelled) {
                PulsatingTextView.this.cancelPulse();
            }
        }

        public void onAnimationStart(Animator animation) {
        }

        public void onAnimationEnd(Animator animation) {
        }

        public void onAnimationCancel(Animator animation) {
        }
    }
}

