/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.network.mock;

import com.shopgun.android.sdk.network.Request;
import java.net.MalformedURLException;
import java.net.URL;

public class PathHelper {
    int version = -1;
    int type = -1;
    int action_or_id = -1;
    int itemAction = -1;
    String[] mPath;

    public PathHelper(Request<?> request) {
        try {
            String path = new URL(request.getUrl()).getPath();
            this.mPath = path.split("/");
            this.offset();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public PathHelper(String[] path) {
        this.mPath = path;
        this.offset();
    }

    private void offset() {
        for (int i = 0; i < this.mPath.length; ++i) {
            if (!"v2".equals(this.mPath[i])) continue;
            this.setVersionOffset(i);
        }
    }

    private void setVersionOffset(int versionIndex) {
        this.version = versionIndex;
        this.type = versionIndex + 1;
        this.action_or_id = versionIndex + 2;
        this.itemAction = versionIndex + 3;
    }

    public String getApiVersion() {
        return this.get(this.version);
    }

    public boolean hasType() {
        return this.mPath.length >= this.type;
    }

    public String getType() {
        return this.get(this.type);
    }

    public boolean hasActionOrId() {
        return this.mPath.length >= this.action_or_id;
    }

    public String getActionOrId() {
        return this.get(this.action_or_id);
    }

    public boolean hasAction() {
        return this.mPath.length >= this.type;
    }

    public String getItemAction() {
        return this.get(this.itemAction);
    }

    private String get(int index) {
        try {
            return this.mPath[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }
}

