/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.network.mock;

import android.content.Context;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.network.NetworkResponse;
import com.shopgun.android.sdk.network.Request;
import com.shopgun.android.sdk.network.mock.MockApiNetworkResponse;
import com.shopgun.android.sdk.utils.SgnUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

public class MockApiSessionResponse
extends MockApiNetworkResponse {
    public MockApiSessionResponse(Context context, Request<?> request) {
        super(context, request);
    }

    @Override
    public NetworkResponse getResponse() {
        JSONObject session = this.getAssetJSONObject("session.json");
        long exp = System.currentTimeMillis() + TimeUnit.HOURS.toMillis(24L);
        try {
            session.put("expires", (Object)SgnUtils.dateToString(new Date(exp)));
        }
        catch (JSONException e) {
            SgnLog.e(TAG, e.getMessage(), e);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-Token", "mock-token");
        headers.put("X-Signature", "mock-signature");
        return new NetworkResponse(200, session.toString().getBytes(), headers);
    }
}

