/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.network.impl;

import com.shopgun.android.sdk.network.Cache;
import com.shopgun.android.sdk.network.NetworkResponse;
import com.shopgun.android.sdk.network.Request;
import com.shopgun.android.sdk.network.Response;
import com.shopgun.android.sdk.network.ShopGunError;
import com.shopgun.android.sdk.network.impl.JsonCacheHelper;
import com.shopgun.android.sdk.network.impl.JsonRequest;
import com.shopgun.android.sdk.network.impl.ParseError;
import com.shopgun.android.sdk.utils.Constants;
import com.shopgun.android.sdk.utils.SgnUtils;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonObjectRequest
extends JsonRequest<JSONObject> {
    public static final String TAG = Constants.getTag(JsonObjectRequest.class);
    private static final long CACHE_TTL = TimeUnit.MINUTES.toMillis(3L);

    public JsonObjectRequest(String url, Response.Listener<JSONObject> listener) {
        super(url, listener);
    }

    public JsonObjectRequest(Request.Method method, String url, JSONObject requestBody, Response.Listener<JSONObject> listener) {
        super(method, url, requestBody == null ? null : requestBody.toString(), listener);
    }

    @Override
    protected Response<JSONObject> parseNetworkResponse(NetworkResponse response) {
        String jsonString = null;
        try {
            try {
                jsonString = new String(response.data, this.getParamsEncoding());
            }
            catch (UnsupportedEncodingException e) {
                jsonString = new String(response.data);
            }
            JSONObject item = new JSONObject(jsonString);
            Response<JSONObject> r = null;
            if (SgnUtils.isSuccess(response.statusCode)) {
                JsonCacheHelper.cacheJSONObject(this, item);
                r = Response.fromSuccess(item, this.getCache());
            } else {
                ShopGunError e = ShopGunError.fromJSON(item);
                r = Response.fromError(e);
            }
            return r;
        }
        catch (JSONException e) {
            return Response.fromError(new ParseError((Exception)((Object)e), JSONObject.class));
        }
    }

    @Override
    public long getCacheTTL() {
        return CACHE_TTL;
    }

    @Override
    public Response<JSONObject> parseCache(Cache c) {
        Response<JSONObject> cache = JsonCacheHelper.getJSONObject(this, c);
        return cache;
    }
}

