/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.network.impl;

import com.shopgun.android.sdk.network.Cache;
import com.shopgun.android.sdk.network.NetworkResponse;
import com.shopgun.android.sdk.network.Request;
import com.shopgun.android.sdk.network.Response;
import com.shopgun.android.sdk.network.ShopGunError;
import com.shopgun.android.sdk.network.impl.JsonCacheHelper;
import com.shopgun.android.sdk.network.impl.JsonRequest;
import com.shopgun.android.sdk.network.impl.ParseError;
import com.shopgun.android.sdk.utils.SgnUtils;
import com.shopgun.android.utils.TextUtils;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonArrayRequest
extends JsonRequest<JSONArray> {
    public static final int DEFAULT_LIMIT = 24;
    private static final String ERROR_OFFSET_NEGATIVE = "Offset may not be negative";
    private static final String ERROR_LIMIT_NEGATIVE = "Limit may not be negative";
    private static final long CACHE_TTL = TimeUnit.MINUTES.toMillis(3L);

    public JsonArrayRequest(String url, Response.Listener<JSONArray> listener) {
        super(Request.Method.GET, url, null, listener);
        this.init();
    }

    public JsonArrayRequest(Request.Method method, String url, Response.Listener<JSONArray> listener) {
        super(method, url, null, listener);
        this.init();
    }

    public JsonArrayRequest(Request.Method method, String url, JSONArray requestBody, Response.Listener<JSONArray> listener) {
        super(method, url, requestBody == null ? null : requestBody.toString(), listener);
        this.init();
    }

    public JsonArrayRequest(Request.Method method, String url, JSONObject requestBody, Response.Listener<JSONArray> listener) {
        super(method, url, requestBody == null ? null : requestBody.toString(), listener);
        this.init();
    }

    private void init() {
        this.setOffset(0);
        this.setLimit(24);
    }

    @Override
    protected Response<JSONArray> parseNetworkResponse(NetworkResponse response) {
        String jsonString = "";
        try {
            try {
                jsonString = new String(response.data, this.getParamsEncoding());
            }
            catch (UnsupportedEncodingException e) {
                jsonString = new String(response.data);
            }
            Response<Object> r = null;
            if (SgnUtils.isSuccess(response.statusCode)) {
                JSONArray jArray = new JSONArray(jsonString);
                r = Response.fromSuccess(jArray, this.getCache());
                JsonCacheHelper.cacheJSONArray(this, (JSONArray)r.result);
            } else {
                JSONObject jObject = new JSONObject(jsonString);
                ShopGunError e = ShopGunError.fromJSON(jObject);
                r = Response.fromError(e);
            }
            return r;
        }
        catch (Exception e) {
            return Response.fromError(new ParseError(e, JSONArray.class));
        }
    }

    @Override
    public Response<JSONArray> parseCache(Cache c) {
        return JsonCacheHelper.getJSONArray(this, c);
    }

    @Override
    public long getCacheTTL() {
        return CACHE_TTL;
    }

    public Request<?> setOrderBy(String order) {
        this.getParameters().put("order_by", order);
        return this;
    }

    public Request<?> setOrderBy(String[] order) {
        if (order != null && order.length != 0) {
            String tmp = TextUtils.join((CharSequence)",", (Object[])order);
            this.getParameters().put("order_by", tmp);
        }
        return this;
    }

    public Request<?> setOrderBy(List<String> order) {
        if (!order.isEmpty()) {
            String tmp = TextUtils.join((CharSequence)",", order);
            this.getParameters().put("order_by", tmp);
        }
        return this;
    }

    public String getOrderBy() {
        return this.getParameters().get("order_by");
    }

    public Request<?> setOffset(int offset) {
        if (offset < 0) {
            throw new IllegalStateException(ERROR_OFFSET_NEGATIVE);
        }
        this.getParameters().put("offset", String.valueOf(offset));
        return this;
    }

    public int getOffset() {
        return Integer.valueOf(this.getParameters().get("offset"));
    }

    public Request<?> setLimit(int limit) {
        if (limit < 0) {
            throw new IllegalStateException(ERROR_LIMIT_NEGATIVE);
        }
        this.getParameters().put("limit", String.valueOf(limit));
        return this;
    }

    public int getLimit() {
        return Integer.valueOf(this.getParameters().get("limit"));
    }

    public Request<?> setIds(String type, Set<String> ids) {
        if (!ids.isEmpty()) {
            String idList = TextUtils.join((CharSequence)",", ids);
            this.getParameters().put(type, idList);
        }
        return this;
    }
}

